/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVirtualMfaDeviceRequest
extends IamRequest
implements ToCopyableBuilder<Builder, CreateVirtualMfaDeviceRequest> {
    private final String path;
    private final String virtualMFADeviceName;

    private CreateVirtualMfaDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.path = builder.path;
        this.virtualMFADeviceName = builder.virtualMFADeviceName;
    }

    public String path() {
        return this.path;
    }

    public String virtualMFADeviceName() {
        return this.virtualMFADeviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualMFADeviceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVirtualMfaDeviceRequest)) {
            return false;
        }
        CreateVirtualMfaDeviceRequest other = (CreateVirtualMfaDeviceRequest)((Object)obj);
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.virtualMFADeviceName(), other.virtualMFADeviceName());
    }

    public String toString() {
        return ToString.builder((String)"CreateVirtualMfaDeviceRequest").add("Path", (Object)this.path()).add("VirtualMFADeviceName", (Object)this.virtualMFADeviceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "VirtualMFADeviceName": {
                return Optional.ofNullable(clazz.cast(this.virtualMFADeviceName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String path;
        private String virtualMFADeviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVirtualMfaDeviceRequest model) {
            super(model);
            this.path(model.path);
            this.virtualMFADeviceName(model.virtualMFADeviceName);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getVirtualMFADeviceName() {
            return this.virtualMFADeviceName;
        }

        @Override
        public final Builder virtualMFADeviceName(String virtualMFADeviceName) {
            this.virtualMFADeviceName = virtualMFADeviceName;
            return this;
        }

        public final void setVirtualMFADeviceName(String virtualMFADeviceName) {
            this.virtualMFADeviceName = virtualMFADeviceName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVirtualMfaDeviceRequest build() {
            return new CreateVirtualMfaDeviceRequest(this);
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    CopyableBuilder<Builder, CreateVirtualMfaDeviceRequest> {
        public Builder path(String var1);

        public Builder virtualMFADeviceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

