/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddClientIdToOpenIdConnectProviderRequest
extends IamRequest
implements ToCopyableBuilder<Builder, AddClientIdToOpenIdConnectProviderRequest> {
    private final String openIDConnectProviderArn;
    private final String clientID;

    private AddClientIdToOpenIdConnectProviderRequest(BuilderImpl builder) {
        super(builder);
        this.openIDConnectProviderArn = builder.openIDConnectProviderArn;
        this.clientID = builder.clientID;
    }

    public String openIDConnectProviderArn() {
        return this.openIDConnectProviderArn;
    }

    public String clientID() {
        return this.clientID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.openIDConnectProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientID());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddClientIdToOpenIdConnectProviderRequest)) {
            return false;
        }
        AddClientIdToOpenIdConnectProviderRequest other = (AddClientIdToOpenIdConnectProviderRequest)((Object)obj);
        return Objects.equals(this.openIDConnectProviderArn(), other.openIDConnectProviderArn()) && Objects.equals(this.clientID(), other.clientID());
    }

    public String toString() {
        return ToString.builder((String)"AddClientIdToOpenIdConnectProviderRequest").add("OpenIDConnectProviderArn", (Object)this.openIDConnectProviderArn()).add("ClientID", (Object)this.clientID()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OpenIDConnectProviderArn": {
                return Optional.ofNullable(clazz.cast(this.openIDConnectProviderArn()));
            }
            case "ClientID": {
                return Optional.ofNullable(clazz.cast(this.clientID()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String openIDConnectProviderArn;
        private String clientID;

        private BuilderImpl() {
        }

        private BuilderImpl(AddClientIdToOpenIdConnectProviderRequest model) {
            super(model);
            this.openIDConnectProviderArn(model.openIDConnectProviderArn);
            this.clientID(model.clientID);
        }

        public final String getOpenIDConnectProviderArn() {
            return this.openIDConnectProviderArn;
        }

        @Override
        public final Builder openIDConnectProviderArn(String openIDConnectProviderArn) {
            this.openIDConnectProviderArn = openIDConnectProviderArn;
            return this;
        }

        public final void setOpenIDConnectProviderArn(String openIDConnectProviderArn) {
            this.openIDConnectProviderArn = openIDConnectProviderArn;
        }

        public final String getClientID() {
            return this.clientID;
        }

        @Override
        public final Builder clientID(String clientID) {
            this.clientID = clientID;
            return this;
        }

        public final void setClientID(String clientID) {
            this.clientID = clientID;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddClientIdToOpenIdConnectProviderRequest build() {
            return new AddClientIdToOpenIdConnectProviderRequest(this);
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    CopyableBuilder<Builder, AddClientIdToOpenIdConnectProviderRequest> {
        public Builder openIDConnectProviderArn(String var1);

        public Builder clientID(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

