/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.UploadServerCertificateRequest;

public class UploadServerCertificateRequestMarshaller
implements Marshaller<Request<UploadServerCertificateRequest>, UploadServerCertificateRequest> {
    public Request<UploadServerCertificateRequest> marshall(UploadServerCertificateRequest uploadServerCertificateRequest) {
        if (uploadServerCertificateRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)uploadServerCertificateRequest, "IamClient");
        request.addParameter("Action", "UploadServerCertificate");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (uploadServerCertificateRequest.path() != null) {
            request.addParameter("Path", StringConversion.fromString((String)uploadServerCertificateRequest.path()));
        }
        if (uploadServerCertificateRequest.serverCertificateName() != null) {
            request.addParameter("ServerCertificateName", StringConversion.fromString((String)uploadServerCertificateRequest.serverCertificateName()));
        }
        if (uploadServerCertificateRequest.certificateBody() != null) {
            request.addParameter("CertificateBody", StringConversion.fromString((String)uploadServerCertificateRequest.certificateBody()));
        }
        if (uploadServerCertificateRequest.privateKey() != null) {
            request.addParameter("PrivateKey", StringConversion.fromString((String)uploadServerCertificateRequest.privateKey()));
        }
        if (uploadServerCertificateRequest.certificateChain() != null) {
            request.addParameter("CertificateChain", StringConversion.fromString((String)uploadServerCertificateRequest.certificateChain()));
        }
        return request;
    }
}

