/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.ContextEntry;
import software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyRequest;

public class SimulatePrincipalPolicyRequestMarshaller
implements Marshaller<Request<SimulatePrincipalPolicyRequest>, SimulatePrincipalPolicyRequest> {
    public Request<SimulatePrincipalPolicyRequest> marshall(SimulatePrincipalPolicyRequest simulatePrincipalPolicyRequest) {
        if (simulatePrincipalPolicyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)simulatePrincipalPolicyRequest, "IamClient");
        request.addParameter("Action", "SimulatePrincipalPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (simulatePrincipalPolicyRequest.policySourceArn() != null) {
            request.addParameter("PolicySourceArn", StringConversion.fromString((String)simulatePrincipalPolicyRequest.policySourceArn()));
        }
        if (simulatePrincipalPolicyRequest.policyInputList().isEmpty() && !(simulatePrincipalPolicyRequest.policyInputList() instanceof SdkAutoConstructList)) {
            request.addParameter("PolicyInputList", "");
        } else if (!simulatePrincipalPolicyRequest.policyInputList().isEmpty() && !(simulatePrincipalPolicyRequest.policyInputList() instanceof SdkAutoConstructList)) {
            List<String> policyInputListList = simulatePrincipalPolicyRequest.policyInputList();
            int policyInputListListIndex = 1;
            for (String policyInputListListValue : policyInputListList) {
                if (policyInputListListValue != null) {
                    request.addParameter("PolicyInputList.member." + policyInputListListIndex, StringConversion.fromString((String)policyInputListListValue));
                }
                ++policyInputListListIndex;
            }
        }
        if (simulatePrincipalPolicyRequest.actionNames().isEmpty() && !(simulatePrincipalPolicyRequest.actionNames() instanceof SdkAutoConstructList)) {
            request.addParameter("ActionNames", "");
        } else if (!simulatePrincipalPolicyRequest.actionNames().isEmpty() && !(simulatePrincipalPolicyRequest.actionNames() instanceof SdkAutoConstructList)) {
            List<String> actionNamesList = simulatePrincipalPolicyRequest.actionNames();
            int actionNamesListIndex = 1;
            for (String actionNamesListValue : actionNamesList) {
                if (actionNamesListValue != null) {
                    request.addParameter("ActionNames.member." + actionNamesListIndex, StringConversion.fromString((String)actionNamesListValue));
                }
                ++actionNamesListIndex;
            }
        }
        if (simulatePrincipalPolicyRequest.resourceArns().isEmpty() && !(simulatePrincipalPolicyRequest.resourceArns() instanceof SdkAutoConstructList)) {
            request.addParameter("ResourceArns", "");
        } else if (!simulatePrincipalPolicyRequest.resourceArns().isEmpty() && !(simulatePrincipalPolicyRequest.resourceArns() instanceof SdkAutoConstructList)) {
            List<String> resourceArnsList = simulatePrincipalPolicyRequest.resourceArns();
            int resourceArnsListIndex = 1;
            for (String resourceArnsListValue : resourceArnsList) {
                if (resourceArnsListValue != null) {
                    request.addParameter("ResourceArns.member." + resourceArnsListIndex, StringConversion.fromString((String)resourceArnsListValue));
                }
                ++resourceArnsListIndex;
            }
        }
        if (simulatePrincipalPolicyRequest.resourcePolicy() != null) {
            request.addParameter("ResourcePolicy", StringConversion.fromString((String)simulatePrincipalPolicyRequest.resourcePolicy()));
        }
        if (simulatePrincipalPolicyRequest.resourceOwner() != null) {
            request.addParameter("ResourceOwner", StringConversion.fromString((String)simulatePrincipalPolicyRequest.resourceOwner()));
        }
        if (simulatePrincipalPolicyRequest.callerArn() != null) {
            request.addParameter("CallerArn", StringConversion.fromString((String)simulatePrincipalPolicyRequest.callerArn()));
        }
        if (simulatePrincipalPolicyRequest.contextEntries().isEmpty() && !(simulatePrincipalPolicyRequest.contextEntries() instanceof SdkAutoConstructList)) {
            request.addParameter("ContextEntries", "");
        } else if (!simulatePrincipalPolicyRequest.contextEntries().isEmpty() && !(simulatePrincipalPolicyRequest.contextEntries() instanceof SdkAutoConstructList)) {
            List<ContextEntry> contextEntriesList = simulatePrincipalPolicyRequest.contextEntries();
            int contextEntriesListIndex = 1;
            for (ContextEntry contextEntriesListValue : contextEntriesList) {
                if (contextEntriesListValue.contextKeyName() != null) {
                    request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyName", StringConversion.fromString((String)contextEntriesListValue.contextKeyName()));
                }
                if (contextEntriesListValue.contextKeyValues().isEmpty() && !(contextEntriesListValue.contextKeyValues() instanceof SdkAutoConstructList)) {
                    request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyValues", "");
                } else if (!contextEntriesListValue.contextKeyValues().isEmpty() && !(contextEntriesListValue.contextKeyValues() instanceof SdkAutoConstructList)) {
                    List<String> contextKeyValuesList = contextEntriesListValue.contextKeyValues();
                    int contextKeyValuesListIndex = 1;
                    for (String contextKeyValuesListValue : contextKeyValuesList) {
                        if (contextKeyValuesListValue != null) {
                            request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyValues.member." + contextKeyValuesListIndex, StringConversion.fromString((String)contextKeyValuesListValue));
                        }
                        ++contextKeyValuesListIndex;
                    }
                }
                if (contextEntriesListValue.contextKeyTypeAsString() != null) {
                    request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyType", StringConversion.fromString((String)contextEntriesListValue.contextKeyTypeAsString()));
                }
                ++contextEntriesListIndex;
            }
        }
        if (simulatePrincipalPolicyRequest.resourceHandlingOption() != null) {
            request.addParameter("ResourceHandlingOption", StringConversion.fromString((String)simulatePrincipalPolicyRequest.resourceHandlingOption()));
        }
        if (simulatePrincipalPolicyRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringConversion.fromInteger((Integer)simulatePrincipalPolicyRequest.maxItems()));
        }
        if (simulatePrincipalPolicyRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)simulatePrincipalPolicyRequest.marker()));
        }
        return request;
    }
}

