/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.ListRolesRequest;

public class ListRolesRequestMarshaller
implements Marshaller<Request<ListRolesRequest>, ListRolesRequest> {
    public Request<ListRolesRequest> marshall(ListRolesRequest listRolesRequest) {
        if (listRolesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listRolesRequest, "IamClient");
        request.addParameter("Action", "ListRoles");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listRolesRequest.pathPrefix() != null) {
            request.addParameter("PathPrefix", StringConversion.fromString((String)listRolesRequest.pathPrefix()));
        }
        if (listRolesRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)listRolesRequest.marker()));
        }
        if (listRolesRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringConversion.fromInteger((Integer)listRolesRequest.maxItems()));
        }
        return request;
    }
}

