/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest;

public class ListRolePoliciesRequestMarshaller
implements Marshaller<Request<ListRolePoliciesRequest>, ListRolePoliciesRequest> {
    public Request<ListRolePoliciesRequest> marshall(ListRolePoliciesRequest listRolePoliciesRequest) {
        if (listRolePoliciesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listRolePoliciesRequest, "IamClient");
        request.addParameter("Action", "ListRolePolicies");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listRolePoliciesRequest.roleName() != null) {
            request.addParameter("RoleName", StringConversion.fromString((String)listRolePoliciesRequest.roleName()));
        }
        if (listRolePoliciesRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)listRolePoliciesRequest.marker()));
        }
        if (listRolePoliciesRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringConversion.fromInteger((Integer)listRolePoliciesRequest.maxItems()));
        }
        return request;
    }
}

