/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleRequest;

public class CreateServiceLinkedRoleRequestMarshaller
implements Marshaller<Request<CreateServiceLinkedRoleRequest>, CreateServiceLinkedRoleRequest> {
    public Request<CreateServiceLinkedRoleRequest> marshall(CreateServiceLinkedRoleRequest createServiceLinkedRoleRequest) {
        if (createServiceLinkedRoleRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createServiceLinkedRoleRequest, "IamClient");
        request.addParameter("Action", "CreateServiceLinkedRole");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createServiceLinkedRoleRequest.awsServiceName() != null) {
            request.addParameter("AWSServiceName", StringConversion.fromString((String)createServiceLinkedRoleRequest.awsServiceName()));
        }
        if (createServiceLinkedRoleRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)createServiceLinkedRoleRequest.description()));
        }
        if (createServiceLinkedRoleRequest.customSuffix() != null) {
            request.addParameter("CustomSuffix", StringConversion.fromString((String)createServiceLinkedRoleRequest.customSuffix()));
        }
        return request;
    }
}

