/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.CreateSamlProviderRequest;

public class CreateSamlProviderRequestMarshaller
implements Marshaller<Request<CreateSamlProviderRequest>, CreateSamlProviderRequest> {
    public Request<CreateSamlProviderRequest> marshall(CreateSamlProviderRequest createSamlProviderRequest) {
        if (createSamlProviderRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createSamlProviderRequest, "IamClient");
        request.addParameter("Action", "CreateSAMLProvider");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createSamlProviderRequest.samlMetadataDocument() != null) {
            request.addParameter("SAMLMetadataDocument", StringConversion.fromString((String)createSamlProviderRequest.samlMetadataDocument()));
        }
        if (createSamlProviderRequest.name() != null) {
            request.addParameter("Name", StringConversion.fromString((String)createSamlProviderRequest.name()));
        }
        return request;
    }
}

