/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.CreateGroupRequest;

public class CreateGroupRequestMarshaller
implements Marshaller<Request<CreateGroupRequest>, CreateGroupRequest> {
    public Request<CreateGroupRequest> marshall(CreateGroupRequest createGroupRequest) {
        if (createGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createGroupRequest, "IamClient");
        request.addParameter("Action", "CreateGroup");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createGroupRequest.path() != null) {
            request.addParameter("Path", StringConversion.fromString((String)createGroupRequest.path()));
        }
        if (createGroupRequest.groupName() != null) {
            request.addParameter("GroupName", StringConversion.fromString((String)createGroupRequest.groupName()));
        }
        return request;
    }
}

