/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListGroupPoliciesResponse;

public class ListGroupPoliciesPublisher
implements SdkPublisher<ListGroupPoliciesResponse> {
    private final IamAsyncClient client;
    private final ListGroupPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGroupPoliciesPublisher(IamAsyncClient client, ListGroupPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGroupPoliciesPublisher(IamAsyncClient client, ListGroupPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGroupPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGroupPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> policyNames() {
        Function<ListGroupPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyNames() != null) {
                return response.policyNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGroupPoliciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListGroupPoliciesPublisher resume(ListGroupPoliciesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListGroupPoliciesPublisher(this.client, (ListGroupPoliciesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListGroupPoliciesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListGroupPoliciesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListGroupPoliciesResponseFetcher
    implements AsyncPageFetcher<ListGroupPoliciesResponse> {
        private ListGroupPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupPoliciesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListGroupPoliciesResponse> nextPage(ListGroupPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListGroupPoliciesPublisher.this.client.listGroupPolicies(ListGroupPoliciesPublisher.this.firstRequest);
            }
            return ListGroupPoliciesPublisher.this.client.listGroupPolicies((ListGroupPoliciesRequest)((Object)ListGroupPoliciesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

