/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesResponse;

public class ListAttachedUserPoliciesPublisher
implements SdkPublisher<ListAttachedUserPoliciesResponse> {
    private final IamAsyncClient client;
    private final ListAttachedUserPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAttachedUserPoliciesPublisher(IamAsyncClient client, ListAttachedUserPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAttachedUserPoliciesPublisher(IamAsyncClient client, ListAttachedUserPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAttachedUserPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAttachedUserPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AttachedPolicy> attachedPolicies() {
        Function<ListAttachedUserPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.attachedPolicies() != null) {
                return response.attachedPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAttachedUserPoliciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListAttachedUserPoliciesPublisher resume(ListAttachedUserPoliciesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAttachedUserPoliciesPublisher(this.client, (ListAttachedUserPoliciesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListAttachedUserPoliciesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListAttachedUserPoliciesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListAttachedUserPoliciesResponseFetcher
    implements AsyncPageFetcher<ListAttachedUserPoliciesResponse> {
        private ListAttachedUserPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachedUserPoliciesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListAttachedUserPoliciesResponse> nextPage(ListAttachedUserPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAttachedUserPoliciesPublisher.this.client.listAttachedUserPolicies(ListAttachedUserPoliciesPublisher.this.firstRequest);
            }
            return ListAttachedUserPoliciesPublisher.this.client.listAttachedUserPolicies((ListAttachedUserPoliciesRequest)((Object)ListAttachedUserPoliciesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

