/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteSigningCertificateRequest
extends IamRequest
implements ToCopyableBuilder<Builder, DeleteSigningCertificateRequest> {
    private final String userName;
    private final String certificateId;

    private DeleteSigningCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.certificateId = builder.certificateId;
    }

    public String userName() {
        return this.userName;
    }

    public String certificateId() {
        return this.certificateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSigningCertificateRequest)) {
            return false;
        }
        DeleteSigningCertificateRequest other = (DeleteSigningCertificateRequest)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.certificateId(), other.certificateId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteSigningCertificateRequest").add("UserName", (Object)this.userName()).add("CertificateId", (Object)this.certificateId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "CertificateId": {
                return Optional.ofNullable(clazz.cast(this.certificateId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String userName;
        private String certificateId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSigningCertificateRequest model) {
            super(model);
            this.userName(model.userName);
            this.certificateId(model.certificateId);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSigningCertificateRequest build() {
            return new DeleteSigningCertificateRequest(this);
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    CopyableBuilder<Builder, DeleteSigningCertificateRequest> {
        public Builder userName(String var1);

        public Builder certificateId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

