/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.UpdateUserRequest;

public class UpdateUserRequestMarshaller
implements Marshaller<Request<UpdateUserRequest>, UpdateUserRequest> {
    public Request<UpdateUserRequest> marshall(UpdateUserRequest updateUserRequest) {
        if (updateUserRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)updateUserRequest, "IAMClient");
        request.addParameter("Action", "UpdateUser");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateUserRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)updateUserRequest.userName()));
        }
        if (updateUserRequest.newPath() != null) {
            request.addParameter("NewPath", StringUtils.fromString((String)updateUserRequest.newPath()));
        }
        if (updateUserRequest.newUserName() != null) {
            request.addParameter("NewUserName", StringUtils.fromString((String)updateUserRequest.newUserName()));
        }
        return request;
    }
}

