/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.DeleteSSHPublicKeyRequest;

public class DeleteSSHPublicKeyRequestMarshaller
implements Marshaller<Request<DeleteSSHPublicKeyRequest>, DeleteSSHPublicKeyRequest> {
    public Request<DeleteSSHPublicKeyRequest> marshall(DeleteSSHPublicKeyRequest deleteSSHPublicKeyRequest) {
        if (deleteSSHPublicKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)deleteSSHPublicKeyRequest, "IAMClient");
        request.addParameter("Action", "DeleteSSHPublicKey");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteSSHPublicKeyRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)deleteSSHPublicKeyRequest.userName()));
        }
        if (deleteSSHPublicKeyRequest.sshPublicKeyId() != null) {
            request.addParameter("SSHPublicKeyId", StringUtils.fromString((String)deleteSSHPublicKeyRequest.sshPublicKeyId()));
        }
        return request;
    }
}

