/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.iam.IAMAsyncClient;
import software.amazon.awssdk.services.iam.model.ListVirtualMFADevicesRequest;
import software.amazon.awssdk.services.iam.model.ListVirtualMFADevicesResponse;
import software.amazon.awssdk.services.iam.model.VirtualMFADevice;

public class ListVirtualMFADevicesPublisher
implements SdkPublisher<ListVirtualMFADevicesResponse> {
    private final IAMAsyncClient client;
    private final ListVirtualMFADevicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVirtualMFADevicesPublisher(IAMAsyncClient client, ListVirtualMFADevicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVirtualMFADevicesPublisher(IAMAsyncClient client, ListVirtualMFADevicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVirtualMFADevicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVirtualMFADevicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<VirtualMFADevice> virtualMFADevices() {
        Function<ListVirtualMFADevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.virtualMFADevices() != null) {
                return response.virtualMFADevices().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListVirtualMFADevicesResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListVirtualMFADevicesPublisher resume(ListVirtualMFADevicesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListVirtualMFADevicesPublisher(this.client, (ListVirtualMFADevicesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListVirtualMFADevicesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListVirtualMFADevicesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListVirtualMFADevicesResponseFetcher
    implements AsyncPageFetcher<ListVirtualMFADevicesResponse> {
        private ListVirtualMFADevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListVirtualMFADevicesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListVirtualMFADevicesResponse> nextPage(ListVirtualMFADevicesResponse previousPage) {
            if (previousPage == null) {
                return ListVirtualMFADevicesPublisher.this.client.listVirtualMFADevices(ListVirtualMFADevicesPublisher.this.firstRequest);
            }
            return ListVirtualMFADevicesPublisher.this.client.listVirtualMFADevices((ListVirtualMFADevicesRequest)((Object)ListVirtualMFADevicesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

