/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListVirtualMFADevicesRequest;
import software.amazon.awssdk.services.iam.model.ListVirtualMFADevicesResponse;
import software.amazon.awssdk.services.iam.model.VirtualMFADevice;

public class ListVirtualMFADevicesIterable
implements SdkIterable<ListVirtualMFADevicesResponse> {
    private final IAMClient client;
    private final ListVirtualMFADevicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVirtualMFADevicesIterable(IAMClient client, ListVirtualMFADevicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListVirtualMFADevicesResponseFetcher();
    }

    public Iterator<ListVirtualMFADevicesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<VirtualMFADevice> virtualMFADevices() {
        Function<ListVirtualMFADevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.virtualMFADevices() != null) {
                return response.virtualMFADevices().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListVirtualMFADevicesIterable resume(ListVirtualMFADevicesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListVirtualMFADevicesIterable(this.client, (ListVirtualMFADevicesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListVirtualMFADevicesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListVirtualMFADevicesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListVirtualMFADevicesResponseFetcher
    implements SyncPageFetcher<ListVirtualMFADevicesResponse> {
        private ListVirtualMFADevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListVirtualMFADevicesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListVirtualMFADevicesResponse nextPage(ListVirtualMFADevicesResponse previousPage) {
            if (previousPage == null) {
                return ListVirtualMFADevicesIterable.this.client.listVirtualMFADevices(ListVirtualMFADevicesIterable.this.firstRequest);
            }
            return ListVirtualMFADevicesIterable.this.client.listVirtualMFADevices((ListVirtualMFADevicesRequest)((Object)ListVirtualMFADevicesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

