/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListMFADevicesRequest;
import software.amazon.awssdk.services.iam.model.ListMFADevicesResponse;
import software.amazon.awssdk.services.iam.model.MFADevice;

public class ListMFADevicesIterable
implements SdkIterable<ListMFADevicesResponse> {
    private final IAMClient client;
    private final ListMFADevicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMFADevicesIterable(IAMClient client, ListMFADevicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMFADevicesResponseFetcher();
    }

    public Iterator<ListMFADevicesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<MFADevice> mfaDevices() {
        Function<ListMFADevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.mfaDevices() != null) {
                return response.mfaDevices().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListMFADevicesIterable resume(ListMFADevicesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListMFADevicesIterable(this.client, (ListMFADevicesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListMFADevicesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListMFADevicesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListMFADevicesResponseFetcher
    implements SyncPageFetcher<ListMFADevicesResponse> {
        private ListMFADevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListMFADevicesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListMFADevicesResponse nextPage(ListMFADevicesResponse previousPage) {
            if (previousPage == null) {
                return ListMFADevicesIterable.this.client.listMFADevices(ListMFADevicesIterable.this.firstRequest);
            }
            return ListMFADevicesIterable.this.client.listMFADevices((ListMFADevicesRequest)((Object)ListMFADevicesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

