/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.Group;
import software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest;
import software.amazon.awssdk.services.iam.model.ListGroupsForUserResponse;

public class ListGroupsForUserIterable
implements SdkIterable<ListGroupsForUserResponse> {
    private final IAMClient client;
    private final ListGroupsForUserRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGroupsForUserIterable(IAMClient client, ListGroupsForUserRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGroupsForUserResponseFetcher();
    }

    public Iterator<ListGroupsForUserResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Group> groups() {
        Function<ListGroupsForUserResponse, Iterator> getIterator = response -> {
            if (response != null && response.groups() != null) {
                return response.groups().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListGroupsForUserIterable resume(ListGroupsForUserResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListGroupsForUserIterable(this.client, (ListGroupsForUserRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListGroupsForUserIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListGroupsForUserResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListGroupsForUserResponseFetcher
    implements SyncPageFetcher<ListGroupsForUserResponse> {
        private ListGroupsForUserResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupsForUserResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListGroupsForUserResponse nextPage(ListGroupsForUserResponse previousPage) {
            if (previousPage == null) {
                return ListGroupsForUserIterable.this.client.listGroupsForUser(ListGroupsForUserIterable.this.firstRequest);
            }
            return ListGroupsForUserIterable.this.client.listGroupsForUser((ListGroupsForUserRequest)((Object)ListGroupsForUserIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

