/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iam.model.IAMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResetServiceSpecificCredentialRequest
extends IAMRequest
implements ToCopyableBuilder<Builder, ResetServiceSpecificCredentialRequest> {
    private final String userName;
    private final String serviceSpecificCredentialId;

    private ResetServiceSpecificCredentialRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.serviceSpecificCredentialId = builder.serviceSpecificCredentialId;
    }

    public String userName() {
        return this.userName;
    }

    public String serviceSpecificCredentialId() {
        return this.serviceSpecificCredentialId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSpecificCredentialId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetServiceSpecificCredentialRequest)) {
            return false;
        }
        ResetServiceSpecificCredentialRequest other = (ResetServiceSpecificCredentialRequest)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.serviceSpecificCredentialId(), other.serviceSpecificCredentialId());
    }

    public String toString() {
        return ToString.builder((String)"ResetServiceSpecificCredentialRequest").add("UserName", (Object)this.userName()).add("ServiceSpecificCredentialId", (Object)this.serviceSpecificCredentialId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "ServiceSpecificCredentialId": {
                return Optional.of(clazz.cast(this.serviceSpecificCredentialId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMRequest.BuilderImpl
    implements Builder {
        private String userName;
        private String serviceSpecificCredentialId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetServiceSpecificCredentialRequest model) {
            super(model);
            this.userName(model.userName);
            this.serviceSpecificCredentialId(model.serviceSpecificCredentialId);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getServiceSpecificCredentialId() {
            return this.serviceSpecificCredentialId;
        }

        @Override
        public final Builder serviceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
            return this;
        }

        public final void setServiceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ResetServiceSpecificCredentialRequest build() {
            return new ResetServiceSpecificCredentialRequest(this);
        }
    }

    public static interface Builder
    extends IAMRequest.Builder,
    CopyableBuilder<Builder, ResetServiceSpecificCredentialRequest> {
        public Builder userName(String var1);

        public Builder serviceSpecificCredentialId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

