/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.iam.model.IAMResponse;
import software.amazon.awssdk.services.iam.model.PolicyVersion;
import software.amazon.awssdk.services.iam.model._policyDocumentVersionListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPolicyVersionsResponse
extends IAMResponse
implements ToCopyableBuilder<Builder, ListPolicyVersionsResponse> {
    private final List<PolicyVersion> versions;
    private final Boolean isTruncated;
    private final String marker;

    private ListPolicyVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.versions = builder.versions;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<PolicyVersion> versions() {
        return this.versions;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.versions());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyVersionsResponse)) {
            return false;
        }
        ListPolicyVersionsResponse other = (ListPolicyVersionsResponse)((Object)obj);
        return Objects.equals(this.versions(), other.versions()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListPolicyVersionsResponse").add("Versions", this.versions()).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Versions": {
                return Optional.of(clazz.cast(this.versions()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMResponse.BuilderImpl
    implements Builder {
        private List<PolicyVersion> versions;
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyVersionsResponse model) {
            super(model);
            this.versions(model.versions);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<PolicyVersion.Builder> getVersions() {
            return this.versions != null ? (Collection)this.versions.stream().map(PolicyVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder versions(Collection<PolicyVersion> versions) {
            this.versions = _policyDocumentVersionListTypeCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(PolicyVersion ... versions) {
            this.versions(Arrays.asList(versions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(Consumer<PolicyVersion.Builder> ... versions) {
            this.versions(Stream.of(versions).map(c -> (PolicyVersion)((PolicyVersion.Builder)PolicyVersion.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVersions(Collection<PolicyVersion.BuilderImpl> versions) {
            this.versions = _policyDocumentVersionListTypeCopier.copyFromBuilder(versions);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListPolicyVersionsResponse build() {
            return new ListPolicyVersionsResponse(this);
        }
    }

    public static interface Builder
    extends IAMResponse.Builder,
    CopyableBuilder<Builder, ListPolicyVersionsResponse> {
        public Builder versions(Collection<PolicyVersion> var1);

        public Builder versions(PolicyVersion ... var1);

        public Builder versions(Consumer<PolicyVersion.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

