/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iam.model.InstanceProfile;
import software.amazon.awssdk.services.iam.model.Role;
import software.amazon.awssdk.services.iam.transform.RoleUnmarshaller;

public class InstanceProfileUnmarshaller
implements Unmarshaller<InstanceProfile, StaxUnmarshallerContext> {
    private static InstanceProfileUnmarshaller INSTANCE;

    public InstanceProfile unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        InstanceProfile.Builder instanceProfile = InstanceProfile.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Path", targetDepth)) {
                    instanceProfile.path(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("InstanceProfileName", targetDepth)) {
                    instanceProfile.instanceProfileName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("InstanceProfileId", targetDepth)) {
                    instanceProfile.instanceProfileId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Arn", targetDepth)) {
                    instanceProfile.arn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreateDate", targetDepth)) {
                    instanceProfile.createDate(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Roles", targetDepth)) {
                    instanceProfile.roles(new ArrayList<Role>());
                    continue;
                }
                if (!context.testExpression("Roles/member", targetDepth)) continue;
                instanceProfile.roles(RoleUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (InstanceProfile)instanceProfile.build();
    }

    public static InstanceProfileUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstanceProfileUnmarshaller();
        }
        return INSTANCE;
    }
}

