/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.policybuilder.iam.internal;

import software.amazon.awssdk.annotations.NotNull;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.policybuilder.iam.IamCondition;
import software.amazon.awssdk.policybuilder.iam.IamConditionKey;
import software.amazon.awssdk.policybuilder.iam.IamConditionOperator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultIamCondition
implements IamCondition {
    @NotNull
    private final IamConditionOperator operator;
    @NotNull
    private final IamConditionKey key;
    @NotNull
    private final String value;

    private DefaultIamCondition(Builder builder) {
        this.operator = (IamConditionOperator)Validate.paramNotNull((Object)builder.operator, (String)"conditionOperator");
        this.key = (IamConditionKey)Validate.paramNotNull((Object)builder.key, (String)"conditionKey");
        this.value = (String)Validate.paramNotNull((Object)builder.value, (String)"conditionValue");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public IamConditionOperator operator() {
        return this.operator;
    }

    @Override
    public IamConditionKey key() {
        return this.key;
    }

    @Override
    public String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIamCondition that = (DefaultIamCondition)o;
        if (!this.operator.equals(that.operator)) {
            return false;
        }
        if (!this.key.equals(that.key)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.operator.hashCode();
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return ToString.builder((String)"IamCondition").add("operator", (Object)this.operator.value()).add("key", (Object)this.key.value()).add("value", (Object)this.value).build();
    }

    public static class Builder
    implements IamCondition.Builder {
        private IamConditionOperator operator;
        private IamConditionKey key;
        private String value;

        private Builder() {
        }

        private Builder(DefaultIamCondition condition) {
            this.operator = condition.operator;
            this.key = condition.key;
            this.value = condition.value;
        }

        @Override
        public IamCondition.Builder operator(IamConditionOperator operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public IamCondition.Builder operator(String operator) {
            this.operator = operator == null ? null : IamConditionOperator.create(operator);
            return this;
        }

        @Override
        public IamCondition.Builder key(IamConditionKey key) {
            this.key = key;
            return this;
        }

        @Override
        public IamCondition.Builder key(String key) {
            this.key = key == null ? null : IamConditionKey.create(key);
            return this;
        }

        @Override
        public IamCondition.Builder value(String value) {
            this.value = value;
            return this;
        }

        public IamCondition build() {
            return new DefaultIamCondition(this);
        }
    }
}

