/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.policybuilder.iam;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.policybuilder.iam.IamPrincipalType;
import software.amazon.awssdk.policybuilder.iam.internal.DefaultIamPrincipal;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@ThreadSafe
public interface IamPrincipal
extends ToCopyableBuilder<Builder, IamPrincipal> {
    public static final IamPrincipal ALL = IamPrincipal.create("*", "*");

    public static IamPrincipal create(IamPrincipalType principalType, String principalId) {
        return (IamPrincipal)IamPrincipal.builder().type(principalType).id(principalId).build();
    }

    public static IamPrincipal create(String principalType, String principalId) {
        return (IamPrincipal)IamPrincipal.builder().type(principalType).id(principalId).build();
    }

    public static List<IamPrincipal> createAll(IamPrincipalType principalType, Collection<String> principalIds) {
        Validate.paramNotNull((Object)principalType, (String)"principalType");
        if (principalIds == null) {
            return Collections.emptyList();
        }
        return principalIds.stream().map(principalId -> IamPrincipal.create(principalType, principalId)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static List<IamPrincipal> createAll(String principalType, Collection<String> principalIds) {
        Validate.paramNotNull((Object)principalType, (String)"principalType");
        if (principalIds == null) {
            return Collections.emptyList();
        }
        return principalIds.stream().map(principalId -> IamPrincipal.create(principalType, principalId)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static Builder builder() {
        return DefaultIamPrincipal.builder();
    }

    public IamPrincipalType type();

    public String id();

    public static interface Builder
    extends CopyableBuilder<Builder, IamPrincipal> {
        public Builder type(IamPrincipalType var1);

        public Builder type(String var1);

        public Builder id(String var1);
    }
}

