/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.policybuilder.iam.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotNull;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.policybuilder.iam.IamPolicy;
import software.amazon.awssdk.policybuilder.iam.IamPolicyWriter;
import software.amazon.awssdk.policybuilder.iam.IamStatement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultIamPolicy
implements IamPolicy {
    private final String id;
    @NotNull
    private final String version;
    @NotNull
    private final List<IamStatement> statements;

    public DefaultIamPolicy(Builder builder) {
        this.id = builder.id;
        this.version = builder.version != null ? builder.version : "2012-10-17";
        this.statements = new ArrayList<IamStatement>(Validate.notEmpty((Collection)builder.statements, (String)"At least one policy statement is required.", (Object[])new Object[0]));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public List<IamStatement> statements() {
        return Collections.unmodifiableList(this.statements);
    }

    @Override
    public String toJson() {
        return this.toJson(IamPolicyWriter.create());
    }

    @Override
    public String toJson(IamPolicyWriter writer) {
        return writer.writeToString(this);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIamPolicy that = (DefaultIamPolicy)o;
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!this.version.equals(that.version)) {
            return false;
        }
        return this.statements.equals(that.statements);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.statements.hashCode();
        return result;
    }

    public String toString() {
        return ToString.builder((String)"IamPolicy").add("id", (Object)this.id).add("version", (Object)this.version).add("statements", this.statements.isEmpty() ? null : this.statements).build();
    }

    public static class Builder
    implements IamPolicy.Builder {
        private String id;
        private String version;
        private final List<IamStatement> statements = new ArrayList<IamStatement>();

        private Builder() {
        }

        private Builder(DefaultIamPolicy policy) {
            this.id = policy.id;
            this.version = policy.version;
            this.statements.addAll(policy.statements);
        }

        @Override
        public IamPolicy.Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public IamPolicy.Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public IamPolicy.Builder statements(Collection<IamStatement> statements) {
            this.statements.clear();
            if (statements != null) {
                this.statements.addAll(statements);
            }
            return this;
        }

        @Override
        public IamPolicy.Builder addStatement(IamStatement statement) {
            Validate.paramNotNull((Object)statement, (String)"statement");
            this.statements.add(statement);
            return this;
        }

        @Override
        public IamPolicy.Builder addStatement(Consumer<IamStatement.Builder> statement) {
            Validate.paramNotNull(statement, (String)"statement");
            this.statements.add((IamStatement)((IamStatement.Builder)IamStatement.builder().applyMutation(statement)).build());
            return this;
        }

        public IamPolicy build() {
            return new DefaultIamPolicy(this);
        }
    }
}

