/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.policybuilder.iam.internal;

import software.amazon.awssdk.annotations.NotNull;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.policybuilder.iam.IamConditionOperator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultIamConditionOperator
implements IamConditionOperator {
    @NotNull
    private final String value;

    public DefaultIamConditionOperator(String value) {
        this.value = (String)Validate.paramNotNull((Object)value, (String)"conditionOperatorValue");
    }

    @Override
    public IamConditionOperator addPrefix(String prefix) {
        Validate.paramNotNull((Object)prefix, (String)"prefix");
        return IamConditionOperator.create(prefix + this.value);
    }

    @Override
    public IamConditionOperator addSuffix(String suffix) {
        Validate.paramNotNull((Object)suffix, (String)"suffix");
        return IamConditionOperator.create(this.value + suffix);
    }

    @Override
    public String value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIamConditionOperator that = (DefaultIamConditionOperator)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return ToString.builder((String)"IamConditionOperator").add("value", (Object)this.value).build();
    }
}

