/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.policybuilder.iam;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.policybuilder.iam.IamPolicyReader;
import software.amazon.awssdk.policybuilder.iam.IamPolicyWriter;
import software.amazon.awssdk.policybuilder.iam.IamStatement;
import software.amazon.awssdk.policybuilder.iam.internal.DefaultIamPolicy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@ThreadSafe
public interface IamPolicy
extends ToCopyableBuilder<Builder, IamPolicy> {
    public static IamPolicy fromJson(String json) {
        return IamPolicyReader.create().read(json);
    }

    public static IamPolicy create(Collection<IamStatement> statements) {
        return (IamPolicy)IamPolicy.builder().statements(statements).build();
    }

    public static Builder builder() {
        return DefaultIamPolicy.builder();
    }

    public String id();

    public String version();

    public List<IamStatement> statements();

    public String toJson();

    public String toJson(IamPolicyWriter var1);

    public static interface Builder
    extends CopyableBuilder<Builder, IamPolicy> {
        public Builder id(String var1);

        public Builder version(String var1);

        public Builder statements(Collection<IamStatement> var1);

        public Builder addStatement(IamStatement var1);

        public Builder addStatement(Consumer<IamStatement.Builder> var1);
    }
}

