/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.DefaultSdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public interface SdkHttpFullResponse
extends SdkHttpResponse,
ToCopyableBuilder<Builder, SdkHttpFullResponse> {
    public AbortableInputStream getContent();

    public static Builder builder() {
        return new DefaultSdkHttpFullResponse.Builder();
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SdkHttpFullResponse> {
        public Builder statusText(String var1);

        public Builder statusCode(int var1);

        public Builder content(AbortableInputStream var1);

        @ReviewBeforeRelease(value="Should we only allow setting the AbortableInputStream?")
        public Builder content(InputStream var1);

        public Builder headers(Map<String, List<String>> var1);

        @ReviewBeforeRelease(value="This is completely different from the HTTP request. This should be the same between both interfaces.")
        public Builder addHeader(String var1, List<String> var2);
    }
}

