/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.DefaultSdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpResponse;

public interface SdkHttpFullResponse
extends SdkHttpResponse {
    public AbortableInputStream getContent();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        String statusText;
        int statusCode;
        AbortableInputStream content;
        Map<String, List<String>> headers = new HashMap<String, List<String>>();

        private Builder() {
        }

        public Builder statusText(String statusText) {
            this.statusText = statusText;
            return this;
        }

        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder content(AbortableInputStream content) {
            this.content = content;
            return this;
        }

        @ReviewBeforeRelease(value="Should we only allow setting the AbortableInputStream?")
        public Builder content(InputStream content) {
            return this.content(new AbortableInputStream(content, () -> {}));
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public Builder header(String headerName, List<String> headerValues) {
            this.headers.put(headerName, headerValues);
            return this;
        }

        public SdkHttpFullResponse build() {
            return new DefaultSdkHttpFullResponse(this);
        }
    }
}

