/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains the options specified by the sumitter of the import request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportOptions implements SdkPojo, Serializable, ToCopyableBuilder<ImportOptions.Builder, ImportOptions> {
    private static final SdkField<DestinationOptions> DESTINATION_OPTIONS_FIELD = SdkField
            .<DestinationOptions> builder(MarshallingType.SDK_POJO).memberName("destinationOptions")
            .getter(getter(ImportOptions::destinationOptions)).setter(setter(Builder::destinationOptions))
            .constructor(DestinationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationOptions").build())
            .build();

    private static final SdkField<DelimitedTextImportOptions> DELIMITED_TEXT_OPTIONS_FIELD = SdkField
            .<DelimitedTextImportOptions> builder(MarshallingType.SDK_POJO).memberName("delimitedTextOptions")
            .getter(getter(ImportOptions::delimitedTextOptions)).setter(setter(Builder::delimitedTextOptions))
            .constructor(DelimitedTextImportOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delimitedTextOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_OPTIONS_FIELD,
            DELIMITED_TEXT_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final DestinationOptions destinationOptions;

    private final DelimitedTextImportOptions delimitedTextOptions;

    private ImportOptions(BuilderImpl builder) {
        this.destinationOptions = builder.destinationOptions;
        this.delimitedTextOptions = builder.delimitedTextOptions;
    }

    /**
     * <p>
     * Options relating to the destination of the import request.
     * </p>
     * 
     * @return Options relating to the destination of the import request.
     */
    public final DestinationOptions destinationOptions() {
        return destinationOptions;
    }

    /**
     * <p>
     * Options relating to parsing delimited text. Required if dataFormat is DELIMITED_TEXT.
     * </p>
     * 
     * @return Options relating to parsing delimited text. Required if dataFormat is DELIMITED_TEXT.
     */
    public final DelimitedTextImportOptions delimitedTextOptions() {
        return delimitedTextOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(delimitedTextOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportOptions)) {
            return false;
        }
        ImportOptions other = (ImportOptions) obj;
        return Objects.equals(destinationOptions(), other.destinationOptions())
                && Objects.equals(delimitedTextOptions(), other.delimitedTextOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportOptions").add("DestinationOptions", destinationOptions())
                .add("DelimitedTextOptions", delimitedTextOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destinationOptions":
            return Optional.ofNullable(clazz.cast(destinationOptions()));
        case "delimitedTextOptions":
            return Optional.ofNullable(clazz.cast(delimitedTextOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportOptions, T> g) {
        return obj -> g.apply((ImportOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportOptions> {
        /**
         * <p>
         * Options relating to the destination of the import request.
         * </p>
         * 
         * @param destinationOptions
         *        Options relating to the destination of the import request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationOptions(DestinationOptions destinationOptions);

        /**
         * <p>
         * Options relating to the destination of the import request.
         * </p>
         * This is a convenience that creates an instance of the {@link DestinationOptions.Builder} avoiding the need to
         * create one manually via {@link DestinationOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationOptions(DestinationOptions)}.
         * 
         * @param destinationOptions
         *        a consumer that will call methods on {@link DestinationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationOptions(DestinationOptions)
         */
        default Builder destinationOptions(Consumer<DestinationOptions.Builder> destinationOptions) {
            return destinationOptions(DestinationOptions.builder().applyMutation(destinationOptions).build());
        }

        /**
         * <p>
         * Options relating to parsing delimited text. Required if dataFormat is DELIMITED_TEXT.
         * </p>
         * 
         * @param delimitedTextOptions
         *        Options relating to parsing delimited text. Required if dataFormat is DELIMITED_TEXT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delimitedTextOptions(DelimitedTextImportOptions delimitedTextOptions);

        /**
         * <p>
         * Options relating to parsing delimited text. Required if dataFormat is DELIMITED_TEXT.
         * </p>
         * This is a convenience that creates an instance of the {@link DelimitedTextImportOptions.Builder} avoiding the
         * need to create one manually via {@link DelimitedTextImportOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link DelimitedTextImportOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #delimitedTextOptions(DelimitedTextImportOptions)}.
         * 
         * @param delimitedTextOptions
         *        a consumer that will call methods on {@link DelimitedTextImportOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delimitedTextOptions(DelimitedTextImportOptions)
         */
        default Builder delimitedTextOptions(Consumer<DelimitedTextImportOptions.Builder> delimitedTextOptions) {
            return delimitedTextOptions(DelimitedTextImportOptions.builder().applyMutation(delimitedTextOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DestinationOptions destinationOptions;

        private DelimitedTextImportOptions delimitedTextOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportOptions model) {
            destinationOptions(model.destinationOptions);
            delimitedTextOptions(model.delimitedTextOptions);
        }

        public final DestinationOptions.Builder getDestinationOptions() {
            return destinationOptions != null ? destinationOptions.toBuilder() : null;
        }

        @Override
        public final Builder destinationOptions(DestinationOptions destinationOptions) {
            this.destinationOptions = destinationOptions;
            return this;
        }

        public final void setDestinationOptions(DestinationOptions.BuilderImpl destinationOptions) {
            this.destinationOptions = destinationOptions != null ? destinationOptions.build() : null;
        }

        public final DelimitedTextImportOptions.Builder getDelimitedTextOptions() {
            return delimitedTextOptions != null ? delimitedTextOptions.toBuilder() : null;
        }

        @Override
        public final Builder delimitedTextOptions(DelimitedTextImportOptions delimitedTextOptions) {
            this.delimitedTextOptions = delimitedTextOptions;
            return this;
        }

        public final void setDelimitedTextOptions(DelimitedTextImportOptions.BuilderImpl delimitedTextOptions) {
            this.delimitedTextOptions = delimitedTextOptions != null ? delimitedTextOptions.build() : null;
        }

        @Override
        public ImportOptions build() {
            return new ImportOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
