/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.honeycode.model.BatchCreateTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.BatchCreateTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.BatchDeleteTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.BatchDeleteTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.BatchUpdateTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.BatchUpdateTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.BatchUpsertTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.BatchUpsertTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.DescribeTableDataImportJobRequest;
import software.amazon.awssdk.services.honeycode.model.DescribeTableDataImportJobResponse;
import software.amazon.awssdk.services.honeycode.model.GetScreenDataRequest;
import software.amazon.awssdk.services.honeycode.model.GetScreenDataResponse;
import software.amazon.awssdk.services.honeycode.model.InvokeScreenAutomationRequest;
import software.amazon.awssdk.services.honeycode.model.InvokeScreenAutomationResponse;
import software.amazon.awssdk.services.honeycode.model.ListTableColumnsRequest;
import software.amazon.awssdk.services.honeycode.model.ListTableColumnsResponse;
import software.amazon.awssdk.services.honeycode.model.ListTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.ListTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.ListTablesRequest;
import software.amazon.awssdk.services.honeycode.model.ListTablesResponse;
import software.amazon.awssdk.services.honeycode.model.QueryTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.QueryTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.StartTableDataImportJobRequest;
import software.amazon.awssdk.services.honeycode.model.StartTableDataImportJobResponse;
import software.amazon.awssdk.services.honeycode.paginators.ListTableColumnsPublisher;
import software.amazon.awssdk.services.honeycode.paginators.ListTableRowsPublisher;
import software.amazon.awssdk.services.honeycode.paginators.ListTablesPublisher;
import software.amazon.awssdk.services.honeycode.paginators.QueryTableRowsPublisher;

/**
 * Service client for accessing Honeycode asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon Honeycode is a fully managed service that allows you to quickly build mobile and web apps for teams—without
 * programming. Build Honeycode apps for managing almost anything, like projects, customers, operations, approvals,
 * resources, and even your team.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface HoneycodeAsyncClient extends SdkClient {
    String SERVICE_NAME = "honeycode";

    /**
     * Create a {@link HoneycodeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static HoneycodeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link HoneycodeAsyncClient}.
     */
    static HoneycodeAsyncClientBuilder builder() {
        return new DefaultHoneycodeAsyncClientBuilder();
    }

    /**
     * <p>
     * The BatchCreateTableRows API allows you to create one or more rows at the end of a table in a workbook. The API
     * allows you to specify the values to set in some or all of the columns in the new rows.
     * </p>
     * <p>
     * If a column is not explicitly set in a specific row, then the column level formula specified in the table will be
     * applied to the new row. If there is no column level formula but the last row of the table has a formula, then
     * that formula will be copied down to the new row. If there is no column level formula and no formula in the last
     * row of the table, then that column will be left blank for the new rows.
     * </p>
     *
     * @param batchCreateTableRowsRequest
     * @return A Java Future containing the result of the BatchCreateTableRows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceQuotaExceededException The request caused service quota to be breached.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.BatchCreateTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchCreateTableRows" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchCreateTableRowsResponse> batchCreateTableRows(
            BatchCreateTableRowsRequest batchCreateTableRowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The BatchCreateTableRows API allows you to create one or more rows at the end of a table in a workbook. The API
     * allows you to specify the values to set in some or all of the columns in the new rows.
     * </p>
     * <p>
     * If a column is not explicitly set in a specific row, then the column level formula specified in the table will be
     * applied to the new row. If there is no column level formula but the last row of the table has a formula, then
     * that formula will be copied down to the new row. If there is no column level formula and no formula in the last
     * row of the table, then that column will be left blank for the new rows.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreateTableRowsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchCreateTableRowsRequest#builder()}
     * </p>
     *
     * @param batchCreateTableRowsRequest
     *        A {@link Consumer} that will call methods on {@link BatchCreateTableRowsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchCreateTableRows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceQuotaExceededException The request caused service quota to be breached.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.BatchCreateTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchCreateTableRows" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchCreateTableRowsResponse> batchCreateTableRows(
            Consumer<BatchCreateTableRowsRequest.Builder> batchCreateTableRowsRequest) {
        return batchCreateTableRows(BatchCreateTableRowsRequest.builder().applyMutation(batchCreateTableRowsRequest).build());
    }

    /**
     * <p>
     * The BatchDeleteTableRows API allows you to delete one or more rows from a table in a workbook. You need to
     * specify the ids of the rows that you want to delete from the table.
     * </p>
     *
     * @param batchDeleteTableRowsRequest
     * @return A Java Future containing the result of the BatchDeleteTableRows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.BatchDeleteTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchDeleteTableRows" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDeleteTableRowsResponse> batchDeleteTableRows(
            BatchDeleteTableRowsRequest batchDeleteTableRowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The BatchDeleteTableRows API allows you to delete one or more rows from a table in a workbook. You need to
     * specify the ids of the rows that you want to delete from the table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteTableRowsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeleteTableRowsRequest#builder()}
     * </p>
     *
     * @param batchDeleteTableRowsRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteTableRowsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDeleteTableRows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.BatchDeleteTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchDeleteTableRows" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDeleteTableRowsResponse> batchDeleteTableRows(
            Consumer<BatchDeleteTableRowsRequest.Builder> batchDeleteTableRowsRequest) {
        return batchDeleteTableRows(BatchDeleteTableRowsRequest.builder().applyMutation(batchDeleteTableRowsRequest).build());
    }

    /**
     * <p>
     * The BatchUpdateTableRows API allows you to update one or more rows in a table in a workbook.
     * </p>
     * <p>
     * You can specify the values to set in some or all of the columns in the table for the specified rows. If a column
     * is not explicitly specified in a particular row, then that column will not be updated for that row. To clear out
     * the data in a specific cell, you need to set the value as an empty string ("").
     * </p>
     *
     * @param batchUpdateTableRowsRequest
     * @return A Java Future containing the result of the BatchUpdateTableRows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.BatchUpdateTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchUpdateTableRows" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchUpdateTableRowsResponse> batchUpdateTableRows(
            BatchUpdateTableRowsRequest batchUpdateTableRowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The BatchUpdateTableRows API allows you to update one or more rows in a table in a workbook.
     * </p>
     * <p>
     * You can specify the values to set in some or all of the columns in the table for the specified rows. If a column
     * is not explicitly specified in a particular row, then that column will not be updated for that row. To clear out
     * the data in a specific cell, you need to set the value as an empty string ("").
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateTableRowsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdateTableRowsRequest#builder()}
     * </p>
     *
     * @param batchUpdateTableRowsRequest
     *        A {@link Consumer} that will call methods on {@link BatchUpdateTableRowsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchUpdateTableRows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.BatchUpdateTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchUpdateTableRows" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchUpdateTableRowsResponse> batchUpdateTableRows(
            Consumer<BatchUpdateTableRowsRequest.Builder> batchUpdateTableRowsRequest) {
        return batchUpdateTableRows(BatchUpdateTableRowsRequest.builder().applyMutation(batchUpdateTableRowsRequest).build());
    }

    /**
     * <p>
     * The BatchUpsertTableRows API allows you to upsert one or more rows in a table. The upsert operation takes a
     * filter expression as input and evaluates it to find matching rows on the destination table. If matching rows are
     * found, it will update the cells in the matching rows to new values specified in the request. If no matching rows
     * are found, a new row is added at the end of the table and the cells in that row are set to the new values
     * specified in the request.
     * </p>
     * <p>
     * You can specify the values to set in some or all of the columns in the table for the matching or newly appended
     * rows. If a column is not explicitly specified for a particular row, then that column will not be updated for that
     * row. To clear out the data in a specific cell, you need to set the value as an empty string ("").
     * </p>
     *
     * @param batchUpsertTableRowsRequest
     * @return A Java Future containing the result of the BatchUpsertTableRows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceQuotaExceededException The request caused service quota to be breached.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.BatchUpsertTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchUpsertTableRows" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchUpsertTableRowsResponse> batchUpsertTableRows(
            BatchUpsertTableRowsRequest batchUpsertTableRowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The BatchUpsertTableRows API allows you to upsert one or more rows in a table. The upsert operation takes a
     * filter expression as input and evaluates it to find matching rows on the destination table. If matching rows are
     * found, it will update the cells in the matching rows to new values specified in the request. If no matching rows
     * are found, a new row is added at the end of the table and the cells in that row are set to the new values
     * specified in the request.
     * </p>
     * <p>
     * You can specify the values to set in some or all of the columns in the table for the matching or newly appended
     * rows. If a column is not explicitly specified for a particular row, then that column will not be updated for that
     * row. To clear out the data in a specific cell, you need to set the value as an empty string ("").
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpsertTableRowsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpsertTableRowsRequest#builder()}
     * </p>
     *
     * @param batchUpsertTableRowsRequest
     *        A {@link Consumer} that will call methods on {@link BatchUpsertTableRowsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchUpsertTableRows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceQuotaExceededException The request caused service quota to be breached.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.BatchUpsertTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/BatchUpsertTableRows" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchUpsertTableRowsResponse> batchUpsertTableRows(
            Consumer<BatchUpsertTableRowsRequest.Builder> batchUpsertTableRowsRequest) {
        return batchUpsertTableRows(BatchUpsertTableRowsRequest.builder().applyMutation(batchUpsertTableRowsRequest).build());
    }

    /**
     * <p>
     * The DescribeTableDataImportJob API allows you to retrieve the status and details of a table data import job.
     * </p>
     *
     * @param describeTableDataImportJobRequest
     * @return A Java Future containing the result of the DescribeTableDataImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.DescribeTableDataImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/DescribeTableDataImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTableDataImportJobResponse> describeTableDataImportJob(
            DescribeTableDataImportJobRequest describeTableDataImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The DescribeTableDataImportJob API allows you to retrieve the status and details of a table data import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTableDataImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTableDataImportJobRequest#builder()}
     * </p>
     *
     * @param describeTableDataImportJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTableDataImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeTableDataImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.DescribeTableDataImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/DescribeTableDataImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTableDataImportJobResponse> describeTableDataImportJob(
            Consumer<DescribeTableDataImportJobRequest.Builder> describeTableDataImportJobRequest) {
        return describeTableDataImportJob(DescribeTableDataImportJobRequest.builder()
                .applyMutation(describeTableDataImportJobRequest).build());
    }

    /**
     * <p>
     * The GetScreenData API allows retrieval of data from a screen in a Honeycode app. The API allows setting local
     * variables in the screen to filter, sort or otherwise affect what will be displayed on the screen.
     * </p>
     *
     * @param getScreenDataRequest
     * @return A Java Future containing the result of the GetScreenData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.GetScreenData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/GetScreenData" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetScreenDataResponse> getScreenData(GetScreenDataRequest getScreenDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The GetScreenData API allows retrieval of data from a screen in a Honeycode app. The API allows setting local
     * variables in the screen to filter, sort or otherwise affect what will be displayed on the screen.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetScreenDataRequest.Builder} avoiding the need to
     * create one manually via {@link GetScreenDataRequest#builder()}
     * </p>
     *
     * @param getScreenDataRequest
     *        A {@link Consumer} that will call methods on {@link GetScreenDataRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetScreenData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.GetScreenData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/GetScreenData" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetScreenDataResponse> getScreenData(Consumer<GetScreenDataRequest.Builder> getScreenDataRequest) {
        return getScreenData(GetScreenDataRequest.builder().applyMutation(getScreenDataRequest).build());
    }

    /**
     * <p>
     * The InvokeScreenAutomation API allows invoking an action defined in a screen in a Honeycode app. The API allows
     * setting local variables, which can then be used in the automation being invoked. This allows automating the
     * Honeycode app interactions to write, update or delete data in the workbook.
     * </p>
     *
     * @param invokeScreenAutomationRequest
     * @return A Java Future containing the result of the InvokeScreenAutomation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>AutomationExecutionException The automation execution did not end successfully.</li>
     *         <li>AutomationExecutionTimeoutException The automation execution timed out.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.InvokeScreenAutomation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/InvokeScreenAutomation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<InvokeScreenAutomationResponse> invokeScreenAutomation(
            InvokeScreenAutomationRequest invokeScreenAutomationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The InvokeScreenAutomation API allows invoking an action defined in a screen in a Honeycode app. The API allows
     * setting local variables, which can then be used in the automation being invoked. This allows automating the
     * Honeycode app interactions to write, update or delete data in the workbook.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeScreenAutomationRequest.Builder} avoiding the
     * need to create one manually via {@link InvokeScreenAutomationRequest#builder()}
     * </p>
     *
     * @param invokeScreenAutomationRequest
     *        A {@link Consumer} that will call methods on {@link InvokeScreenAutomationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the InvokeScreenAutomation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>AutomationExecutionException The automation execution did not end successfully.</li>
     *         <li>AutomationExecutionTimeoutException The automation execution timed out.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.InvokeScreenAutomation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/InvokeScreenAutomation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<InvokeScreenAutomationResponse> invokeScreenAutomation(
            Consumer<InvokeScreenAutomationRequest.Builder> invokeScreenAutomationRequest) {
        return invokeScreenAutomation(InvokeScreenAutomationRequest.builder().applyMutation(invokeScreenAutomationRequest)
                .build());
    }

    /**
     * <p>
     * The ListTableColumns API allows you to retrieve a list of all the columns in a table in a workbook.
     * </p>
     *
     * @param listTableColumnsRequest
     * @return A Java Future containing the result of the ListTableColumns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.ListTableColumns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTableColumns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTableColumnsResponse> listTableColumns(ListTableColumnsRequest listTableColumnsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The ListTableColumns API allows you to retrieve a list of all the columns in a table in a workbook.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableColumnsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTableColumnsRequest#builder()}
     * </p>
     *
     * @param listTableColumnsRequest
     *        A {@link Consumer} that will call methods on {@link ListTableColumnsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTableColumns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.ListTableColumns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTableColumns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTableColumnsResponse> listTableColumns(
            Consumer<ListTableColumnsRequest.Builder> listTableColumnsRequest) {
        return listTableColumns(ListTableColumnsRequest.builder().applyMutation(listTableColumnsRequest).build());
    }

    /**
     * <p>
     * The ListTableColumns API allows you to retrieve a list of all the columns in a table in a workbook.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTableColumns(software.amazon.awssdk.services.honeycode.model.ListTableColumnsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTableColumnsPublisher publisher = client.listTableColumnsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTableColumnsPublisher publisher = client.listTableColumnsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.honeycode.model.ListTableColumnsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.honeycode.model.ListTableColumnsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableColumns(software.amazon.awssdk.services.honeycode.model.ListTableColumnsRequest)} operation.</b>
     * </p>
     *
     * @param listTableColumnsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.ListTableColumns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTableColumns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTableColumnsPublisher listTableColumnsPaginator(ListTableColumnsRequest listTableColumnsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The ListTableColumns API allows you to retrieve a list of all the columns in a table in a workbook.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTableColumns(software.amazon.awssdk.services.honeycode.model.ListTableColumnsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTableColumnsPublisher publisher = client.listTableColumnsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTableColumnsPublisher publisher = client.listTableColumnsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.honeycode.model.ListTableColumnsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.honeycode.model.ListTableColumnsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableColumns(software.amazon.awssdk.services.honeycode.model.ListTableColumnsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableColumnsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTableColumnsRequest#builder()}
     * </p>
     *
     * @param listTableColumnsRequest
     *        A {@link Consumer} that will call methods on {@link ListTableColumnsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.ListTableColumns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTableColumns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTableColumnsPublisher listTableColumnsPaginator(Consumer<ListTableColumnsRequest.Builder> listTableColumnsRequest) {
        return listTableColumnsPaginator(ListTableColumnsRequest.builder().applyMutation(listTableColumnsRequest).build());
    }

    /**
     * <p>
     * The ListTableRows API allows you to retrieve a list of all the rows in a table in a workbook.
     * </p>
     *
     * @param listTableRowsRequest
     * @return A Java Future containing the result of the ListTableRows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.ListTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTableRows" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTableRowsResponse> listTableRows(ListTableRowsRequest listTableRowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The ListTableRows API allows you to retrieve a list of all the rows in a table in a workbook.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableRowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTableRowsRequest#builder()}
     * </p>
     *
     * @param listTableRowsRequest
     *        A {@link Consumer} that will call methods on {@link ListTableRowsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTableRows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.ListTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTableRows" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTableRowsResponse> listTableRows(Consumer<ListTableRowsRequest.Builder> listTableRowsRequest) {
        return listTableRows(ListTableRowsRequest.builder().applyMutation(listTableRowsRequest).build());
    }

    /**
     * <p>
     * The ListTableRows API allows you to retrieve a list of all the rows in a table in a workbook.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTableRows(software.amazon.awssdk.services.honeycode.model.ListTableRowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTableRowsPublisher publisher = client.listTableRowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTableRowsPublisher publisher = client.listTableRowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.honeycode.model.ListTableRowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.honeycode.model.ListTableRowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableRows(software.amazon.awssdk.services.honeycode.model.ListTableRowsRequest)} operation.</b>
     * </p>
     *
     * @param listTableRowsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.ListTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTableRows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTableRowsPublisher listTableRowsPaginator(ListTableRowsRequest listTableRowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The ListTableRows API allows you to retrieve a list of all the rows in a table in a workbook.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTableRows(software.amazon.awssdk.services.honeycode.model.ListTableRowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTableRowsPublisher publisher = client.listTableRowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTableRowsPublisher publisher = client.listTableRowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.honeycode.model.ListTableRowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.honeycode.model.ListTableRowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableRows(software.amazon.awssdk.services.honeycode.model.ListTableRowsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableRowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTableRowsRequest#builder()}
     * </p>
     *
     * @param listTableRowsRequest
     *        A {@link Consumer} that will call methods on {@link ListTableRowsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.ListTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTableRows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTableRowsPublisher listTableRowsPaginator(Consumer<ListTableRowsRequest.Builder> listTableRowsRequest) {
        return listTableRowsPaginator(ListTableRowsRequest.builder().applyMutation(listTableRowsRequest).build());
    }

    /**
     * <p>
     * The ListTables API allows you to retrieve a list of all the tables in a workbook.
     * </p>
     *
     * @param listTablesRequest
     * @return A Java Future containing the result of the ListTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.ListTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTablesResponse> listTables(ListTablesRequest listTablesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The ListTables API allows you to retrieve a list of all the tables in a workbook.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTablesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTablesRequest#builder()}
     * </p>
     *
     * @param listTablesRequest
     *        A {@link Consumer} that will call methods on {@link ListTablesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.ListTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTablesResponse> listTables(Consumer<ListTablesRequest.Builder> listTablesRequest) {
        return listTables(ListTablesRequest.builder().applyMutation(listTablesRequest).build());
    }

    /**
     * <p>
     * The ListTables API allows you to retrieve a list of all the tables in a workbook.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTables(software.amazon.awssdk.services.honeycode.model.ListTablesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTablesPublisher publisher = client.listTablesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTablesPublisher publisher = client.listTablesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.honeycode.model.ListTablesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.honeycode.model.ListTablesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTables(software.amazon.awssdk.services.honeycode.model.ListTablesRequest)} operation.</b>
     * </p>
     *
     * @param listTablesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.ListTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTablesPublisher listTablesPaginator(ListTablesRequest listTablesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The ListTables API allows you to retrieve a list of all the tables in a workbook.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTables(software.amazon.awssdk.services.honeycode.model.ListTablesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTablesPublisher publisher = client.listTablesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.ListTablesPublisher publisher = client.listTablesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.honeycode.model.ListTablesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.honeycode.model.ListTablesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTables(software.amazon.awssdk.services.honeycode.model.ListTablesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTablesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTablesRequest#builder()}
     * </p>
     *
     * @param listTablesRequest
     *        A {@link Consumer} that will call methods on {@link ListTablesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.ListTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTablesPublisher listTablesPaginator(Consumer<ListTablesRequest.Builder> listTablesRequest) {
        return listTablesPaginator(ListTablesRequest.builder().applyMutation(listTablesRequest).build());
    }

    /**
     * <p>
     * The QueryTableRows API allows you to use a filter formula to query for specific rows in a table.
     * </p>
     *
     * @param queryTableRowsRequest
     * @return A Java Future containing the result of the QueryTableRows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.QueryTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/QueryTableRows" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<QueryTableRowsResponse> queryTableRows(QueryTableRowsRequest queryTableRowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The QueryTableRows API allows you to use a filter formula to query for specific rows in a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryTableRowsRequest.Builder} avoiding the need to
     * create one manually via {@link QueryTableRowsRequest#builder()}
     * </p>
     *
     * @param queryTableRowsRequest
     *        A {@link Consumer} that will call methods on {@link QueryTableRowsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the QueryTableRows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.QueryTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/QueryTableRows" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<QueryTableRowsResponse> queryTableRows(Consumer<QueryTableRowsRequest.Builder> queryTableRowsRequest) {
        return queryTableRows(QueryTableRowsRequest.builder().applyMutation(queryTableRowsRequest).build());
    }

    /**
     * <p>
     * The QueryTableRows API allows you to use a filter formula to query for specific rows in a table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #queryTableRows(software.amazon.awssdk.services.honeycode.model.QueryTableRowsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.QueryTableRowsPublisher publisher = client.queryTableRowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.QueryTableRowsPublisher publisher = client.queryTableRowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.honeycode.model.QueryTableRowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.honeycode.model.QueryTableRowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #queryTableRows(software.amazon.awssdk.services.honeycode.model.QueryTableRowsRequest)} operation.</b>
     * </p>
     *
     * @param queryTableRowsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.QueryTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/QueryTableRows" target="_top">AWS API
     *      Documentation</a>
     */
    default QueryTableRowsPublisher queryTableRowsPaginator(QueryTableRowsRequest queryTableRowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The QueryTableRows API allows you to use a filter formula to query for specific rows in a table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #queryTableRows(software.amazon.awssdk.services.honeycode.model.QueryTableRowsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.QueryTableRowsPublisher publisher = client.queryTableRowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.honeycode.paginators.QueryTableRowsPublisher publisher = client.queryTableRowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.honeycode.model.QueryTableRowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.honeycode.model.QueryTableRowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #queryTableRows(software.amazon.awssdk.services.honeycode.model.QueryTableRowsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryTableRowsRequest.Builder} avoiding the need to
     * create one manually via {@link QueryTableRowsRequest#builder()}
     * </p>
     *
     * @param queryTableRowsRequest
     *        A {@link Consumer} that will call methods on {@link QueryTableRowsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.QueryTableRows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/QueryTableRows" target="_top">AWS API
     *      Documentation</a>
     */
    default QueryTableRowsPublisher queryTableRowsPaginator(Consumer<QueryTableRowsRequest.Builder> queryTableRowsRequest) {
        return queryTableRowsPaginator(QueryTableRowsRequest.builder().applyMutation(queryTableRowsRequest).build());
    }

    /**
     * <p>
     * The StartTableDataImportJob API allows you to start an import job on a table. This API will only return the id of
     * the job that was started. To find out the status of the import request, you need to call the
     * DescribeTableDataImportJob API.
     * </p>
     *
     * @param startTableDataImportJobRequest
     * @return A Java Future containing the result of the StartTableDataImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.StartTableDataImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/StartTableDataImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartTableDataImportJobResponse> startTableDataImportJob(
            StartTableDataImportJobRequest startTableDataImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The StartTableDataImportJob API allows you to start an import job on a table. This API will only return the id of
     * the job that was started. To find out the status of the import request, you need to call the
     * DescribeTableDataImportJob API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTableDataImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartTableDataImportJobRequest#builder()}
     * </p>
     *
     * @param startTableDataImportJobRequest
     *        A {@link Consumer} that will call methods on {@link StartTableDataImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartTableDataImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action. Check that the
     *         workbook is owned by you and your IAM policy allows access to the resource in the request.</li>
     *         <li>InternalServerException There were unexpected errors from the server.</li>
     *         <li>ResourceNotFoundException A Workbook, Table, App, Screen or Screen Automation was not found with the
     *         given ID.</li>
     *         <li>ServiceUnavailableException Remote service is unreachable.</li>
     *         <li>ThrottlingException Tps(transactions per second) rate reached.</li>
     *         <li>ValidationException Request is invalid. The message in the response contains details on why the
     *         request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HoneycodeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HoneycodeAsyncClient.StartTableDataImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/honeycode-2020-03-01/StartTableDataImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartTableDataImportJobResponse> startTableDataImportJob(
            Consumer<StartTableDataImportJobRequest.Builder> startTableDataImportJobRequest) {
        return startTableDataImportJob(StartTableDataImportJobRequest.builder().applyMutation(startTableDataImportJobRequest)
                .build());
    }
}
