/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.ThreatNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThreatIntelligenceDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThreatIntelligenceDetail> {
    private static final SdkField<String> THREAT_LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ThreatIntelligenceDetail.getter(ThreatIntelligenceDetail::threatListName)).setter(ThreatIntelligenceDetail.setter(Builder::threatListName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatListName").build()}).build();
    private static final SdkField<List<String>> THREAT_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ThreatIntelligenceDetail.getter(ThreatIntelligenceDetail::threatNames)).setter(ThreatIntelligenceDetail.setter(Builder::threatNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THREAT_LIST_NAME_FIELD, THREAT_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String threatListName;
    private final List<String> threatNames;

    private ThreatIntelligenceDetail(BuilderImpl builder) {
        this.threatListName = builder.threatListName;
        this.threatNames = builder.threatNames;
    }

    public String threatListName() {
        return this.threatListName;
    }

    public List<String> threatNames() {
        return this.threatNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.threatListName());
        hashCode = 31 * hashCode + Objects.hashCode(this.threatNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThreatIntelligenceDetail)) {
            return false;
        }
        ThreatIntelligenceDetail other = (ThreatIntelligenceDetail)obj;
        return Objects.equals(this.threatListName(), other.threatListName()) && Objects.equals(this.threatNames(), other.threatNames());
    }

    public String toString() {
        return ToString.builder((String)"ThreatIntelligenceDetail").add("ThreatListName", (Object)this.threatListName()).add("ThreatNames", this.threatNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ThreatListName": {
                return Optional.ofNullable(clazz.cast(this.threatListName()));
            }
            case "ThreatNames": {
                return Optional.ofNullable(clazz.cast(this.threatNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThreatIntelligenceDetail, T> g) {
        return obj -> g.apply((ThreatIntelligenceDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String threatListName;
        private List<String> threatNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ThreatIntelligenceDetail model) {
            this.threatListName(model.threatListName);
            this.threatNames(model.threatNames);
        }

        public final String getThreatListName() {
            return this.threatListName;
        }

        @Override
        public final Builder threatListName(String threatListName) {
            this.threatListName = threatListName;
            return this;
        }

        public final void setThreatListName(String threatListName) {
            this.threatListName = threatListName;
        }

        public final Collection<String> getThreatNames() {
            return this.threatNames;
        }

        @Override
        public final Builder threatNames(Collection<String> threatNames) {
            this.threatNames = ThreatNamesCopier.copy(threatNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatNames(String ... threatNames) {
            this.threatNames(Arrays.asList(threatNames));
            return this;
        }

        public final void setThreatNames(Collection<String> threatNames) {
            this.threatNames = ThreatNamesCopier.copy(threatNames);
        }

        public ThreatIntelligenceDetail build() {
            return new ThreatIntelligenceDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThreatIntelligenceDetail> {
        public Builder threatListName(String var1);

        public Builder threatNames(Collection<String> var1);

        public Builder threatNames(String ... var1);
    }
}

