/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.model.ListMembersRequest;
import software.amazon.awssdk.services.guardduty.model.ListMembersResponse;

public class ListMembersIterable
implements SdkIterable<ListMembersResponse> {
    private final GuardDutyClient client;
    private final ListMembersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMembersIterable(GuardDutyClient client, ListMembersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMembersResponseFetcher();
    }

    public Iterator<ListMembersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMembersResponseFetcher
    implements SyncPageFetcher<ListMembersResponse> {
        private ListMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMembersResponse nextPage(ListMembersResponse previousPage) {
            if (previousPage == null) {
                return ListMembersIterable.this.client.listMembers(ListMembersIterable.this.firstRequest);
            }
            return ListMembersIterable.this.client.listMembers((ListMembersRequest)((Object)ListMembersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

