/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyAsyncClient;
import software.amazon.awssdk.services.guardduty.internal.UserAgentUtils;
import software.amazon.awssdk.services.guardduty.model.ListTrustedEntitySetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListTrustedEntitySetsResponse;

public class ListTrustedEntitySetsPublisher
implements SdkPublisher<ListTrustedEntitySetsResponse> {
    private final GuardDutyAsyncClient client;
    private final ListTrustedEntitySetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTrustedEntitySetsPublisher(GuardDutyAsyncClient client, ListTrustedEntitySetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTrustedEntitySetsPublisher(GuardDutyAsyncClient client, ListTrustedEntitySetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTrustedEntitySetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTrustedEntitySetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> trustedEntitySetIds() {
        Function<ListTrustedEntitySetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trustedEntitySetIds() != null) {
                return response.trustedEntitySetIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTrustedEntitySetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTrustedEntitySetsResponseFetcher
    implements AsyncPageFetcher<ListTrustedEntitySetsResponse> {
        private ListTrustedEntitySetsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrustedEntitySetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTrustedEntitySetsResponse> nextPage(ListTrustedEntitySetsResponse previousPage) {
            if (previousPage == null) {
                return ListTrustedEntitySetsPublisher.this.client.listTrustedEntitySets(ListTrustedEntitySetsPublisher.this.firstRequest);
            }
            return ListTrustedEntitySetsPublisher.this.client.listTrustedEntitySets((ListTrustedEntitySetsRequest)((Object)ListTrustedEntitySetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

