/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.internal.UserAgentUtils;
import software.amazon.awssdk.services.guardduty.model.ListMalwareScansRequest;
import software.amazon.awssdk.services.guardduty.model.ListMalwareScansResponse;
import software.amazon.awssdk.services.guardduty.model.MalwareScan;

public class ListMalwareScansIterable
implements SdkIterable<ListMalwareScansResponse> {
    private final GuardDutyClient client;
    private final ListMalwareScansRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMalwareScansIterable(GuardDutyClient client, ListMalwareScansRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMalwareScansResponseFetcher();
    }

    public Iterator<ListMalwareScansResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MalwareScan> scans() {
        Function<ListMalwareScansResponse, Iterator> getIterator = response -> {
            if (response != null && response.scans() != null) {
                return response.scans().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMalwareScansResponseFetcher
    implements SyncPageFetcher<ListMalwareScansResponse> {
        private ListMalwareScansResponseFetcher() {
        }

        public boolean hasNextPage(ListMalwareScansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMalwareScansResponse nextPage(ListMalwareScansResponse previousPage) {
            if (previousPage == null) {
                return ListMalwareScansIterable.this.client.listMalwareScans(ListMalwareScansIterable.this.firstRequest);
            }
            return ListMalwareScansIterable.this.client.listMalwareScans((ListMalwareScansRequest)((Object)ListMalwareScansIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

