/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MalwareProtectionResourceType {
    EBS_RECOVERY_POINT("EBS_RECOVERY_POINT"),
    EBS_SNAPSHOT("EBS_SNAPSHOT"),
    EBS_VOLUME("EBS_VOLUME"),
    EC2_AMI("EC2_AMI"),
    EC2_INSTANCE("EC2_INSTANCE"),
    EC2_RECOVERY_POINT("EC2_RECOVERY_POINT"),
    S3_RECOVERY_POINT("S3_RECOVERY_POINT"),
    S3_BUCKET("S3_BUCKET"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MalwareProtectionResourceType> VALUE_MAP;
    private final String value;

    private MalwareProtectionResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MalwareProtectionResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MalwareProtectionResourceType> knownValues() {
        EnumSet<MalwareProtectionResourceType> knownValues = EnumSet.allOf(MalwareProtectionResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MalwareProtectionResourceType.class, MalwareProtectionResourceType::toString);
    }
}

