/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.Ec2InstanceUidsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ec2LaunchTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ec2LaunchTemplate> {
    private static final SdkField<List<String>> EC2_INSTANCE_UIDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ec2InstanceUids").getter(Ec2LaunchTemplate.getter(Ec2LaunchTemplate::ec2InstanceUids)).setter(Ec2LaunchTemplate.setter(Builder::ec2InstanceUids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceUids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(Ec2LaunchTemplate.getter(Ec2LaunchTemplate::version)).setter(Ec2LaunchTemplate.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_INSTANCE_UIDS_FIELD, VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Ec2LaunchTemplate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> ec2InstanceUids;
    private final String version;

    private Ec2LaunchTemplate(BuilderImpl builder) {
        this.ec2InstanceUids = builder.ec2InstanceUids;
        this.version = builder.version;
    }

    public final boolean hasEc2InstanceUids() {
        return this.ec2InstanceUids != null && !(this.ec2InstanceUids instanceof SdkAutoConstructList);
    }

    public final List<String> ec2InstanceUids() {
        return this.ec2InstanceUids;
    }

    public final String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2InstanceUids() ? this.ec2InstanceUids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2LaunchTemplate)) {
            return false;
        }
        Ec2LaunchTemplate other = (Ec2LaunchTemplate)obj;
        return this.hasEc2InstanceUids() == other.hasEc2InstanceUids() && Objects.equals(this.ec2InstanceUids(), other.ec2InstanceUids()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"Ec2LaunchTemplate").add("Ec2InstanceUids", this.hasEc2InstanceUids() ? this.ec2InstanceUids() : null).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ec2InstanceUids": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceUids()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ec2InstanceUids", EC2_INSTANCE_UIDS_FIELD);
        map.put("version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ec2LaunchTemplate, T> g) {
        return obj -> g.apply((Ec2LaunchTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> ec2InstanceUids = DefaultSdkAutoConstructList.getInstance();
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2LaunchTemplate model) {
            this.ec2InstanceUids(model.ec2InstanceUids);
            this.version(model.version);
        }

        public final Collection<String> getEc2InstanceUids() {
            if (this.ec2InstanceUids instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ec2InstanceUids;
        }

        public final void setEc2InstanceUids(Collection<String> ec2InstanceUids) {
            this.ec2InstanceUids = Ec2InstanceUidsCopier.copy(ec2InstanceUids);
        }

        @Override
        public final Builder ec2InstanceUids(Collection<String> ec2InstanceUids) {
            this.ec2InstanceUids = Ec2InstanceUidsCopier.copy(ec2InstanceUids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceUids(String ... ec2InstanceUids) {
            this.ec2InstanceUids(Arrays.asList(ec2InstanceUids));
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public Ec2LaunchTemplate build() {
            return new Ec2LaunchTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ec2LaunchTemplate> {
        public Builder ec2InstanceUids(Collection<String> var1);

        public Builder ec2InstanceUids(String ... var1);

        public Builder version(String var1);
    }
}

