/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.ThreatEntitySetIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListThreatEntitySetsResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, ListThreatEntitySetsResponse> {
    private static final SdkField<List<String>> THREAT_ENTITY_SET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ThreatEntitySetIds").getter(ListThreatEntitySetsResponse.getter(ListThreatEntitySetsResponse::threatEntitySetIds)).setter(ListThreatEntitySetsResponse.setter(Builder::threatEntitySetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatEntitySetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListThreatEntitySetsResponse.getter(ListThreatEntitySetsResponse::nextToken)).setter(ListThreatEntitySetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THREAT_ENTITY_SET_IDS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListThreatEntitySetsResponse.memberNameToFieldInitializer();
    private final List<String> threatEntitySetIds;
    private final String nextToken;

    private ListThreatEntitySetsResponse(BuilderImpl builder) {
        super(builder);
        this.threatEntitySetIds = builder.threatEntitySetIds;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasThreatEntitySetIds() {
        return this.threatEntitySetIds != null && !(this.threatEntitySetIds instanceof SdkAutoConstructList);
    }

    public final List<String> threatEntitySetIds() {
        return this.threatEntitySetIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThreatEntitySetIds() ? this.threatEntitySetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThreatEntitySetsResponse)) {
            return false;
        }
        ListThreatEntitySetsResponse other = (ListThreatEntitySetsResponse)((Object)obj);
        return this.hasThreatEntitySetIds() == other.hasThreatEntitySetIds() && Objects.equals(this.threatEntitySetIds(), other.threatEntitySetIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListThreatEntitySetsResponse").add("ThreatEntitySetIds", this.hasThreatEntitySetIds() ? this.threatEntitySetIds() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ThreatEntitySetIds": {
                return Optional.ofNullable(clazz.cast(this.threatEntitySetIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("threatEntitySetIds", THREAT_ENTITY_SET_IDS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListThreatEntitySetsResponse, T> g) {
        return obj -> g.apply((ListThreatEntitySetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private List<String> threatEntitySetIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThreatEntitySetsResponse model) {
            super(model);
            this.threatEntitySetIds(model.threatEntitySetIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getThreatEntitySetIds() {
            if (this.threatEntitySetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.threatEntitySetIds;
        }

        public final void setThreatEntitySetIds(Collection<String> threatEntitySetIds) {
            this.threatEntitySetIds = ThreatEntitySetIdsCopier.copy(threatEntitySetIds);
        }

        @Override
        public final Builder threatEntitySetIds(Collection<String> threatEntitySetIds) {
            this.threatEntitySetIds = ThreatEntitySetIdsCopier.copy(threatEntitySetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatEntitySetIds(String ... threatEntitySetIds) {
            this.threatEntitySetIds(Arrays.asList(threatEntitySetIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListThreatEntitySetsResponse build() {
            return new ListThreatEntitySetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GuardDutyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListThreatEntitySetsResponse> {
        public Builder threatEntitySetIds(Collection<String> var1);

        public Builder threatEntitySetIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

