/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.Tag;
import software.amazon.awssdk.services.guardduty.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RdsLimitlessDbDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RdsLimitlessDbDetails> {
    private static final SdkField<String> DB_SHARD_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbShardGroupIdentifier").getter(RdsLimitlessDbDetails.getter(RdsLimitlessDbDetails::dbShardGroupIdentifier)).setter(RdsLimitlessDbDetails.setter(Builder::dbShardGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbShardGroupIdentifier").build()}).build();
    private static final SdkField<String> DB_SHARD_GROUP_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbShardGroupResourceId").getter(RdsLimitlessDbDetails.getter(RdsLimitlessDbDetails::dbShardGroupResourceId)).setter(RdsLimitlessDbDetails.setter(Builder::dbShardGroupResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbShardGroupResourceId").build()}).build();
    private static final SdkField<String> DB_SHARD_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbShardGroupArn").getter(RdsLimitlessDbDetails.getter(RdsLimitlessDbDetails::dbShardGroupArn)).setter(RdsLimitlessDbDetails.setter(Builder::dbShardGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbShardGroupArn").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(RdsLimitlessDbDetails.getter(RdsLimitlessDbDetails::engine)).setter(RdsLimitlessDbDetails.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(RdsLimitlessDbDetails.getter(RdsLimitlessDbDetails::engineVersion)).setter(RdsLimitlessDbDetails.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()}).build();
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbClusterIdentifier").getter(RdsLimitlessDbDetails.getter(RdsLimitlessDbDetails::dbClusterIdentifier)).setter(RdsLimitlessDbDetails.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbClusterIdentifier").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(RdsLimitlessDbDetails.getter(RdsLimitlessDbDetails::tags)).setter(RdsLimitlessDbDetails.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SHARD_GROUP_IDENTIFIER_FIELD, DB_SHARD_GROUP_RESOURCE_ID_FIELD, DB_SHARD_GROUP_ARN_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RdsLimitlessDbDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dbShardGroupIdentifier;
    private final String dbShardGroupResourceId;
    private final String dbShardGroupArn;
    private final String engine;
    private final String engineVersion;
    private final String dbClusterIdentifier;
    private final List<Tag> tags;

    private RdsLimitlessDbDetails(BuilderImpl builder) {
        this.dbShardGroupIdentifier = builder.dbShardGroupIdentifier;
        this.dbShardGroupResourceId = builder.dbShardGroupResourceId;
        this.dbShardGroupArn = builder.dbShardGroupArn;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.tags = builder.tags;
    }

    public final String dbShardGroupIdentifier() {
        return this.dbShardGroupIdentifier;
    }

    public final String dbShardGroupResourceId() {
        return this.dbShardGroupResourceId;
    }

    public final String dbShardGroupArn() {
        return this.dbShardGroupArn;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbShardGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbShardGroupResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbShardGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsLimitlessDbDetails)) {
            return false;
        }
        RdsLimitlessDbDetails other = (RdsLimitlessDbDetails)obj;
        return Objects.equals(this.dbShardGroupIdentifier(), other.dbShardGroupIdentifier()) && Objects.equals(this.dbShardGroupResourceId(), other.dbShardGroupResourceId()) && Objects.equals(this.dbShardGroupArn(), other.dbShardGroupArn()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"RdsLimitlessDbDetails").add("DbShardGroupIdentifier", (Object)this.dbShardGroupIdentifier()).add("DbShardGroupResourceId", (Object)this.dbShardGroupResourceId()).add("DbShardGroupArn", (Object)this.dbShardGroupArn()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("DbClusterIdentifier", (Object)this.dbClusterIdentifier()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DbShardGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbShardGroupIdentifier()));
            }
            case "DbShardGroupResourceId": {
                return Optional.ofNullable(clazz.cast(this.dbShardGroupResourceId()));
            }
            case "DbShardGroupArn": {
                return Optional.ofNullable(clazz.cast(this.dbShardGroupArn()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "DbClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dbShardGroupIdentifier", DB_SHARD_GROUP_IDENTIFIER_FIELD);
        map.put("dbShardGroupResourceId", DB_SHARD_GROUP_RESOURCE_ID_FIELD);
        map.put("dbShardGroupArn", DB_SHARD_GROUP_ARN_FIELD);
        map.put("engine", ENGINE_FIELD);
        map.put("engineVersion", ENGINE_VERSION_FIELD);
        map.put("dbClusterIdentifier", DB_CLUSTER_IDENTIFIER_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RdsLimitlessDbDetails, T> g) {
        return obj -> g.apply((RdsLimitlessDbDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbShardGroupIdentifier;
        private String dbShardGroupResourceId;
        private String dbShardGroupArn;
        private String engine;
        private String engineVersion;
        private String dbClusterIdentifier;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RdsLimitlessDbDetails model) {
            this.dbShardGroupIdentifier(model.dbShardGroupIdentifier);
            this.dbShardGroupResourceId(model.dbShardGroupResourceId);
            this.dbShardGroupArn(model.dbShardGroupArn);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.tags(model.tags);
        }

        public final String getDbShardGroupIdentifier() {
            return this.dbShardGroupIdentifier;
        }

        public final void setDbShardGroupIdentifier(String dbShardGroupIdentifier) {
            this.dbShardGroupIdentifier = dbShardGroupIdentifier;
        }

        @Override
        public final Builder dbShardGroupIdentifier(String dbShardGroupIdentifier) {
            this.dbShardGroupIdentifier = dbShardGroupIdentifier;
            return this;
        }

        public final String getDbShardGroupResourceId() {
            return this.dbShardGroupResourceId;
        }

        public final void setDbShardGroupResourceId(String dbShardGroupResourceId) {
            this.dbShardGroupResourceId = dbShardGroupResourceId;
        }

        @Override
        public final Builder dbShardGroupResourceId(String dbShardGroupResourceId) {
            this.dbShardGroupResourceId = dbShardGroupResourceId;
            return this;
        }

        public final String getDbShardGroupArn() {
            return this.dbShardGroupArn;
        }

        public final void setDbShardGroupArn(String dbShardGroupArn) {
            this.dbShardGroupArn = dbShardGroupArn;
        }

        @Override
        public final Builder dbShardGroupArn(String dbShardGroupArn) {
            this.dbShardGroupArn = dbShardGroupArn;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RdsLimitlessDbDetails build() {
            return new RdsLimitlessDbDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RdsLimitlessDbDetails> {
        public Builder dbShardGroupIdentifier(String var1);

        public Builder dbShardGroupResourceId(String var1);

        public Builder dbShardGroupArn(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

