/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.UsageFeature;
import software.amazon.awssdk.services.guardduty.model.UsageTopAccountResult;
import software.amazon.awssdk.services.guardduty.model.UsageTopAccountsByFeatureListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UsageTopAccountsResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UsageTopAccountsResult> {
    private static final SdkField<String> FEATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Feature").getter(UsageTopAccountsResult.getter(UsageTopAccountsResult::featureAsString)).setter(UsageTopAccountsResult.setter(Builder::feature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("feature").build()}).build();
    private static final SdkField<List<UsageTopAccountResult>> ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Accounts").getter(UsageTopAccountsResult.getter(UsageTopAccountsResult::accounts)).setter(UsageTopAccountsResult.setter(Builder::accounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageTopAccountResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_FIELD, ACCOUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UsageTopAccountsResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String feature;
    private final List<UsageTopAccountResult> accounts;

    private UsageTopAccountsResult(BuilderImpl builder) {
        this.feature = builder.feature;
        this.accounts = builder.accounts;
    }

    public final UsageFeature feature() {
        return UsageFeature.fromValue(this.feature);
    }

    public final String featureAsString() {
        return this.feature;
    }

    public final boolean hasAccounts() {
        return this.accounts != null && !(this.accounts instanceof SdkAutoConstructList);
    }

    public final List<UsageTopAccountResult> accounts() {
        return this.accounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.featureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccounts() ? this.accounts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageTopAccountsResult)) {
            return false;
        }
        UsageTopAccountsResult other = (UsageTopAccountsResult)obj;
        return Objects.equals(this.featureAsString(), other.featureAsString()) && this.hasAccounts() == other.hasAccounts() && Objects.equals(this.accounts(), other.accounts());
    }

    public final String toString() {
        return ToString.builder((String)"UsageTopAccountsResult").add("Feature", (Object)this.featureAsString()).add("Accounts", this.hasAccounts() ? this.accounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Feature": {
                return Optional.ofNullable(clazz.cast(this.featureAsString()));
            }
            case "Accounts": {
                return Optional.ofNullable(clazz.cast(this.accounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("feature", FEATURE_FIELD);
        map.put("accounts", ACCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UsageTopAccountsResult, T> g) {
        return obj -> g.apply((UsageTopAccountsResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String feature;
        private List<UsageTopAccountResult> accounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UsageTopAccountsResult model) {
            this.feature(model.feature);
            this.accounts(model.accounts);
        }

        public final String getFeature() {
            return this.feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public final Builder feature(UsageFeature feature) {
            this.feature(feature == null ? null : feature.toString());
            return this;
        }

        public final List<UsageTopAccountResult.Builder> getAccounts() {
            List<UsageTopAccountResult.Builder> result = UsageTopAccountsByFeatureListCopier.copyToBuilder(this.accounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccounts(Collection<UsageTopAccountResult.BuilderImpl> accounts) {
            this.accounts = UsageTopAccountsByFeatureListCopier.copyFromBuilder(accounts);
        }

        @Override
        public final Builder accounts(Collection<UsageTopAccountResult> accounts) {
            this.accounts = UsageTopAccountsByFeatureListCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(UsageTopAccountResult ... accounts) {
            this.accounts(Arrays.asList(accounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(Consumer<UsageTopAccountResult.Builder> ... accounts) {
            this.accounts(Stream.of(accounts).map(c -> (UsageTopAccountResult)((UsageTopAccountResult.Builder)UsageTopAccountResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public UsageTopAccountsResult build() {
            return new UsageTopAccountsResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UsageTopAccountsResult> {
        public Builder feature(String var1);

        public Builder feature(UsageFeature var1);

        public Builder accounts(Collection<UsageTopAccountResult> var1);

        public Builder accounts(UsageTopAccountResult ... var1);

        public Builder accounts(Consumer<UsageTopAccountResult.Builder> ... var1);
    }
}

