/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.FindingCriteria;
import software.amazon.awssdk.services.guardduty.model.FindingStatisticType;
import software.amazon.awssdk.services.guardduty.model.FindingStatisticTypesCopier;
import software.amazon.awssdk.services.guardduty.model.GroupByType;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.services.guardduty.model.OrderBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFindingsStatisticsRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, GetFindingsStatisticsRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(GetFindingsStatisticsRequest.getter(GetFindingsStatisticsRequest::detectorId)).setter(GetFindingsStatisticsRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()}).build();
    private static final SdkField<List<String>> FINDING_STATISTIC_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FindingStatisticTypes").getter(GetFindingsStatisticsRequest.getter(GetFindingsStatisticsRequest::findingStatisticTypesAsStrings)).setter(GetFindingsStatisticsRequest.setter(Builder::findingStatisticTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingStatisticTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FindingCriteria> FINDING_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FindingCriteria").getter(GetFindingsStatisticsRequest.getter(GetFindingsStatisticsRequest::findingCriteria)).setter(GetFindingsStatisticsRequest.setter(Builder::findingCriteria)).constructor(FindingCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingCriteria").build()}).build();
    private static final SdkField<String> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupBy").getter(GetFindingsStatisticsRequest.getter(GetFindingsStatisticsRequest::groupByAsString)).setter(GetFindingsStatisticsRequest.setter(Builder::groupBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupBy").build()}).build();
    private static final SdkField<String> ORDER_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrderBy").getter(GetFindingsStatisticsRequest.getter(GetFindingsStatisticsRequest::orderByAsString)).setter(GetFindingsStatisticsRequest.setter(Builder::orderBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderBy").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetFindingsStatisticsRequest.getter(GetFindingsStatisticsRequest::maxResults)).setter(GetFindingsStatisticsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, FINDING_STATISTIC_TYPES_FIELD, FINDING_CRITERIA_FIELD, GROUP_BY_FIELD, ORDER_BY_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetFindingsStatisticsRequest.memberNameToFieldInitializer();
    private final String detectorId;
    private final List<String> findingStatisticTypes;
    private final FindingCriteria findingCriteria;
    private final String groupBy;
    private final String orderBy;
    private final Integer maxResults;

    private GetFindingsStatisticsRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.findingStatisticTypes = builder.findingStatisticTypes;
        this.findingCriteria = builder.findingCriteria;
        this.groupBy = builder.groupBy;
        this.orderBy = builder.orderBy;
        this.maxResults = builder.maxResults;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    @Deprecated
    public final List<FindingStatisticType> findingStatisticTypes() {
        return FindingStatisticTypesCopier.copyStringToEnum(this.findingStatisticTypes);
    }

    @Deprecated
    public final boolean hasFindingStatisticTypes() {
        return this.findingStatisticTypes != null && !(this.findingStatisticTypes instanceof SdkAutoConstructList);
    }

    @Deprecated
    public final List<String> findingStatisticTypesAsStrings() {
        return this.findingStatisticTypes;
    }

    public final FindingCriteria findingCriteria() {
        return this.findingCriteria;
    }

    public final GroupByType groupBy() {
        return GroupByType.fromValue(this.groupBy);
    }

    public final String groupByAsString() {
        return this.groupBy;
    }

    public final OrderBy orderBy() {
        return OrderBy.fromValue(this.orderBy);
    }

    public final String orderByAsString() {
        return this.orderBy;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingStatisticTypes() ? this.findingStatisticTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.findingCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingsStatisticsRequest)) {
            return false;
        }
        GetFindingsStatisticsRequest other = (GetFindingsStatisticsRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && this.hasFindingStatisticTypes() == other.hasFindingStatisticTypes() && Objects.equals(this.findingStatisticTypesAsStrings(), other.findingStatisticTypesAsStrings()) && Objects.equals(this.findingCriteria(), other.findingCriteria()) && Objects.equals(this.groupByAsString(), other.groupByAsString()) && Objects.equals(this.orderByAsString(), other.orderByAsString()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetFindingsStatisticsRequest").add("DetectorId", (Object)this.detectorId()).add("FindingStatisticTypes", this.hasFindingStatisticTypes() ? this.findingStatisticTypesAsStrings() : null).add("FindingCriteria", (Object)this.findingCriteria()).add("GroupBy", (Object)this.groupByAsString()).add("OrderBy", (Object)this.orderByAsString()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "FindingStatisticTypes": {
                return Optional.ofNullable(clazz.cast(this.findingStatisticTypesAsStrings()));
            }
            case "FindingCriteria": {
                return Optional.ofNullable(clazz.cast(this.findingCriteria()));
            }
            case "GroupBy": {
                return Optional.ofNullable(clazz.cast(this.groupByAsString()));
            }
            case "OrderBy": {
                return Optional.ofNullable(clazz.cast(this.orderByAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("findingStatisticTypes", FINDING_STATISTIC_TYPES_FIELD);
        map.put("findingCriteria", FINDING_CRITERIA_FIELD);
        map.put("groupBy", GROUP_BY_FIELD);
        map.put("orderBy", ORDER_BY_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFindingsStatisticsRequest, T> g) {
        return obj -> g.apply((GetFindingsStatisticsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private List<String> findingStatisticTypes = DefaultSdkAutoConstructList.getInstance();
        private FindingCriteria findingCriteria;
        private String groupBy;
        private String orderBy;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingsStatisticsRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.findingStatisticTypesWithStrings(model.findingStatisticTypes);
            this.findingCriteria(model.findingCriteria);
            this.groupBy(model.groupBy);
            this.orderBy(model.orderBy);
            this.maxResults(model.maxResults);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        @Deprecated
        public final Collection<String> getFindingStatisticTypes() {
            if (this.findingStatisticTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.findingStatisticTypes;
        }

        @Deprecated
        public final void setFindingStatisticTypes(Collection<String> findingStatisticTypes) {
            this.findingStatisticTypes = FindingStatisticTypesCopier.copy(findingStatisticTypes);
        }

        @Override
        @Deprecated
        public final Builder findingStatisticTypesWithStrings(Collection<String> findingStatisticTypes) {
            this.findingStatisticTypes = FindingStatisticTypesCopier.copy(findingStatisticTypes);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder findingStatisticTypesWithStrings(String ... findingStatisticTypes) {
            this.findingStatisticTypesWithStrings(Arrays.asList(findingStatisticTypes));
            return this;
        }

        @Override
        @Deprecated
        public final Builder findingStatisticTypes(Collection<FindingStatisticType> findingStatisticTypes) {
            this.findingStatisticTypes = FindingStatisticTypesCopier.copyEnumToString(findingStatisticTypes);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder findingStatisticTypes(FindingStatisticType ... findingStatisticTypes) {
            this.findingStatisticTypes(Arrays.asList(findingStatisticTypes));
            return this;
        }

        public final FindingCriteria.Builder getFindingCriteria() {
            return this.findingCriteria != null ? this.findingCriteria.toBuilder() : null;
        }

        public final void setFindingCriteria(FindingCriteria.BuilderImpl findingCriteria) {
            this.findingCriteria = findingCriteria != null ? findingCriteria.build() : null;
        }

        @Override
        public final Builder findingCriteria(FindingCriteria findingCriteria) {
            this.findingCriteria = findingCriteria;
            return this;
        }

        public final String getGroupBy() {
            return this.groupBy;
        }

        public final void setGroupBy(String groupBy) {
            this.groupBy = groupBy;
        }

        @Override
        public final Builder groupBy(String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        @Override
        public final Builder groupBy(GroupByType groupBy) {
            this.groupBy(groupBy == null ? null : groupBy.toString());
            return this;
        }

        public final String getOrderBy() {
            return this.orderBy;
        }

        public final void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        @Override
        public final Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public final Builder orderBy(OrderBy orderBy) {
            this.orderBy(orderBy == null ? null : orderBy.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFindingsStatisticsRequest build() {
            return new GetFindingsStatisticsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFindingsStatisticsRequest> {
        public Builder detectorId(String var1);

        @Deprecated
        public Builder findingStatisticTypesWithStrings(Collection<String> var1);

        @Deprecated
        public Builder findingStatisticTypesWithStrings(String ... var1);

        @Deprecated
        public Builder findingStatisticTypes(Collection<FindingStatisticType> var1);

        @Deprecated
        public Builder findingStatisticTypes(FindingStatisticType ... var1);

        public Builder findingCriteria(FindingCriteria var1);

        default public Builder findingCriteria(Consumer<FindingCriteria.Builder> findingCriteria) {
            return this.findingCriteria((FindingCriteria)((FindingCriteria.Builder)FindingCriteria.builder().applyMutation(findingCriteria)).build());
        }

        public Builder groupBy(String var1);

        public Builder groupBy(GroupByType var1);

        public Builder orderBy(String var1);

        public Builder orderBy(OrderBy var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

