/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceStatistics> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ResourceStatistics.getter(ResourceStatistics::accountId)).setter(ResourceStatistics.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<Instant> LAST_GENERATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastGeneratedAt").getter(ResourceStatistics.getter(ResourceStatistics::lastGeneratedAt)).setter(ResourceStatistics.setter(Builder::lastGeneratedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastGeneratedAt").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ResourceStatistics.getter(ResourceStatistics::resourceId)).setter(ResourceStatistics.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ResourceStatistics.getter(ResourceStatistics::resourceType)).setter(ResourceStatistics.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<Integer> TOTAL_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalFindings").getter(ResourceStatistics.getter(ResourceStatistics::totalFindings)).setter(ResourceStatistics.setter(Builder::totalFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalFindings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, LAST_GENERATED_AT_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, TOTAL_FINDINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceStatistics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final Instant lastGeneratedAt;
    private final String resourceId;
    private final String resourceType;
    private final Integer totalFindings;

    private ResourceStatistics(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.lastGeneratedAt = builder.lastGeneratedAt;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.totalFindings = builder.totalFindings;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final Instant lastGeneratedAt() {
        return this.lastGeneratedAt;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final Integer totalFindings() {
        return this.totalFindings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastGeneratedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalFindings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceStatistics)) {
            return false;
        }
        ResourceStatistics other = (ResourceStatistics)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.lastGeneratedAt(), other.lastGeneratedAt()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.totalFindings(), other.totalFindings());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceStatistics").add("AccountId", (Object)this.accountId()).add("LastGeneratedAt", (Object)this.lastGeneratedAt()).add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceType()).add("TotalFindings", (Object)this.totalFindings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "LastGeneratedAt": {
                return Optional.ofNullable(clazz.cast(this.lastGeneratedAt()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "TotalFindings": {
                return Optional.ofNullable(clazz.cast(this.totalFindings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("lastGeneratedAt", LAST_GENERATED_AT_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("totalFindings", TOTAL_FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceStatistics, T> g) {
        return obj -> g.apply((ResourceStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private Instant lastGeneratedAt;
        private String resourceId;
        private String resourceType;
        private Integer totalFindings;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceStatistics model) {
            this.accountId(model.accountId);
            this.lastGeneratedAt(model.lastGeneratedAt);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.totalFindings(model.totalFindings);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Instant getLastGeneratedAt() {
            return this.lastGeneratedAt;
        }

        public final void setLastGeneratedAt(Instant lastGeneratedAt) {
            this.lastGeneratedAt = lastGeneratedAt;
        }

        @Override
        public final Builder lastGeneratedAt(Instant lastGeneratedAt) {
            this.lastGeneratedAt = lastGeneratedAt;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Integer getTotalFindings() {
            return this.totalFindings;
        }

        public final void setTotalFindings(Integer totalFindings) {
            this.totalFindings = totalFindings;
        }

        @Override
        public final Builder totalFindings(Integer totalFindings) {
            this.totalFindings = totalFindings;
            return this;
        }

        public ResourceStatistics build() {
            return new ResourceStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceStatistics> {
        public Builder accountId(String var1);

        public Builder lastGeneratedAt(Instant var1);

        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder totalFindings(Integer var1);
    }
}

