/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.guardduty.model.FilterAction;
import software.amazon.awssdk.services.guardduty.model.FindingCriteria;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFilterResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, GetFilterResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetFilterResponse.getter(GetFilterResponse::name)).setter(GetFilterResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetFilterResponse.getter(GetFilterResponse::description)).setter(GetFilterResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(GetFilterResponse.getter(GetFilterResponse::actionAsString)).setter(GetFilterResponse.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<Integer> RANK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Rank").getter(GetFilterResponse.getter(GetFilterResponse::rank)).setter(GetFilterResponse.setter(Builder::rank)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rank").build()}).build();
    private static final SdkField<FindingCriteria> FINDING_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FindingCriteria").getter(GetFilterResponse.getter(GetFilterResponse::findingCriteria)).setter(GetFilterResponse.setter(Builder::findingCriteria)).constructor(FindingCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingCriteria").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetFilterResponse.getter(GetFilterResponse::tags)).setter(GetFilterResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, ACTION_FIELD, RANK_FIELD, FINDING_CRITERIA_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetFilterResponse.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String action;
    private final Integer rank;
    private final FindingCriteria findingCriteria;
    private final Map<String, String> tags;

    private GetFilterResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.action = builder.action;
        this.rank = builder.rank;
        this.findingCriteria = builder.findingCriteria;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final FilterAction action() {
        return FilterAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final Integer rank() {
        return this.rank;
    }

    public final FindingCriteria findingCriteria() {
        return this.findingCriteria;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rank());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFilterResponse)) {
            return false;
        }
        GetFilterResponse other = (GetFilterResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.rank(), other.rank()) && Objects.equals(this.findingCriteria(), other.findingCriteria()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetFilterResponse").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Action", (Object)this.actionAsString()).add("Rank", (Object)this.rank()).add("FindingCriteria", (Object)this.findingCriteria()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Rank": {
                return Optional.ofNullable(clazz.cast(this.rank()));
            }
            case "FindingCriteria": {
                return Optional.ofNullable(clazz.cast(this.findingCriteria()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("rank", RANK_FIELD);
        map.put("findingCriteria", FINDING_CRITERIA_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFilterResponse, T> g) {
        return obj -> g.apply((GetFilterResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String action;
        private Integer rank;
        private FindingCriteria findingCriteria;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetFilterResponse model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.action(model.action);
            this.rank(model.rank);
            this.findingCriteria(model.findingCriteria);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(FilterAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Integer getRank() {
            return this.rank;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final FindingCriteria.Builder getFindingCriteria() {
            return this.findingCriteria != null ? this.findingCriteria.toBuilder() : null;
        }

        public final void setFindingCriteria(FindingCriteria.BuilderImpl findingCriteria) {
            this.findingCriteria = findingCriteria != null ? findingCriteria.build() : null;
        }

        @Override
        public final Builder findingCriteria(FindingCriteria findingCriteria) {
            this.findingCriteria = findingCriteria;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetFilterResponse build() {
            return new GetFilterResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFilterResponse> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder action(String var1);

        public Builder action(FilterAction var1);

        public Builder rank(Integer var1);

        public Builder findingCriteria(FindingCriteria var1);

        default public Builder findingCriteria(Consumer<FindingCriteria.Builder> findingCriteria) {
            return this.findingCriteria((FindingCriteria)((FindingCriteria.Builder)FindingCriteria.builder().applyMutation(findingCriteria)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

