/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.Threat;
import software.amazon.awssdk.services.guardduty.model.ThreatsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MalwareScanDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MalwareScanDetails> {
    private static final SdkField<List<Threat>> THREATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Threats").getter(MalwareScanDetails.getter(MalwareScanDetails::threats)).setter(MalwareScanDetails.setter(Builder::threats)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threats").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Threat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THREATS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MalwareScanDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Threat> threats;

    private MalwareScanDetails(BuilderImpl builder) {
        this.threats = builder.threats;
    }

    public final boolean hasThreats() {
        return this.threats != null && !(this.threats instanceof SdkAutoConstructList);
    }

    public final List<Threat> threats() {
        return this.threats;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThreats() ? this.threats() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MalwareScanDetails)) {
            return false;
        }
        MalwareScanDetails other = (MalwareScanDetails)obj;
        return this.hasThreats() == other.hasThreats() && Objects.equals(this.threats(), other.threats());
    }

    public final String toString() {
        return ToString.builder((String)"MalwareScanDetails").add("Threats", this.hasThreats() ? this.threats() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Threats": {
                return Optional.ofNullable(clazz.cast(this.threats()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<Threat>>> map = new HashMap<String, SdkField<List<Threat>>>();
        map.put("threats", THREATS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MalwareScanDetails, T> g) {
        return obj -> g.apply((MalwareScanDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Threat> threats = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MalwareScanDetails model) {
            this.threats(model.threats);
        }

        public final List<Threat.Builder> getThreats() {
            List<Threat.Builder> result = ThreatsCopier.copyToBuilder(this.threats);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThreats(Collection<Threat.BuilderImpl> threats) {
            this.threats = ThreatsCopier.copyFromBuilder(threats);
        }

        @Override
        public final Builder threats(Collection<Threat> threats) {
            this.threats = ThreatsCopier.copy(threats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threats(Threat ... threats) {
            this.threats(Arrays.asList(threats));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threats(Consumer<Threat.Builder> ... threats) {
            this.threats(Stream.of(threats).map(c -> (Threat)((Threat.Builder)Threat.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MalwareScanDetails build() {
            return new MalwareScanDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MalwareScanDetails> {
        public Builder threats(Collection<Threat> var1);

        public Builder threats(Threat ... var1);

        public Builder threats(Consumer<Threat.Builder> ... var1);
    }
}

