/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.guardduty.model.CountByCoverageStatusCopier;
import software.amazon.awssdk.services.guardduty.model.CountByResourceTypeCopier;
import software.amazon.awssdk.services.guardduty.model.CoverageStatus;
import software.amazon.awssdk.services.guardduty.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoverageStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoverageStatistics> {
    private static final SdkField<Map<String, Long>> COUNT_BY_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CountByResourceType").getter(CoverageStatistics.getter(CoverageStatistics::countByResourceTypeAsStrings)).setter(CoverageStatistics.setter(Builder::countByResourceTypeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countByResourceType").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Long>> COUNT_BY_COVERAGE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CountByCoverageStatus").getter(CoverageStatistics.getter(CoverageStatistics::countByCoverageStatusAsStrings)).setter(CoverageStatistics.setter(Builder::countByCoverageStatusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countByCoverageStatus").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_BY_RESOURCE_TYPE_FIELD, COUNT_BY_COVERAGE_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CoverageStatistics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, Long> countByResourceType;
    private final Map<String, Long> countByCoverageStatus;

    private CoverageStatistics(BuilderImpl builder) {
        this.countByResourceType = builder.countByResourceType;
        this.countByCoverageStatus = builder.countByCoverageStatus;
    }

    public final Map<ResourceType, Long> countByResourceType() {
        return CountByResourceTypeCopier.copyStringToEnum(this.countByResourceType);
    }

    public final boolean hasCountByResourceType() {
        return this.countByResourceType != null && !(this.countByResourceType instanceof SdkAutoConstructMap);
    }

    public final Map<String, Long> countByResourceTypeAsStrings() {
        return this.countByResourceType;
    }

    public final Map<CoverageStatus, Long> countByCoverageStatus() {
        return CountByCoverageStatusCopier.copyStringToEnum(this.countByCoverageStatus);
    }

    public final boolean hasCountByCoverageStatus() {
        return this.countByCoverageStatus != null && !(this.countByCoverageStatus instanceof SdkAutoConstructMap);
    }

    public final Map<String, Long> countByCoverageStatusAsStrings() {
        return this.countByCoverageStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCountByResourceType() ? this.countByResourceTypeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCountByCoverageStatus() ? this.countByCoverageStatusAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageStatistics)) {
            return false;
        }
        CoverageStatistics other = (CoverageStatistics)obj;
        return this.hasCountByResourceType() == other.hasCountByResourceType() && Objects.equals(this.countByResourceTypeAsStrings(), other.countByResourceTypeAsStrings()) && this.hasCountByCoverageStatus() == other.hasCountByCoverageStatus() && Objects.equals(this.countByCoverageStatusAsStrings(), other.countByCoverageStatusAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"CoverageStatistics").add("CountByResourceType", this.hasCountByResourceType() ? this.countByResourceTypeAsStrings() : null).add("CountByCoverageStatus", this.hasCountByCoverageStatus() ? this.countByCoverageStatusAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CountByResourceType": {
                return Optional.ofNullable(clazz.cast(this.countByResourceTypeAsStrings()));
            }
            case "CountByCoverageStatus": {
                return Optional.ofNullable(clazz.cast(this.countByCoverageStatusAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, Long>>> map = new HashMap<String, SdkField<Map<String, Long>>>();
        map.put("countByResourceType", COUNT_BY_RESOURCE_TYPE_FIELD);
        map.put("countByCoverageStatus", COUNT_BY_COVERAGE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoverageStatistics, T> g) {
        return obj -> g.apply((CoverageStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Long> countByResourceType = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Long> countByCoverageStatus = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageStatistics model) {
            this.countByResourceTypeWithStrings(model.countByResourceType);
            this.countByCoverageStatusWithStrings(model.countByCoverageStatus);
        }

        public final Map<String, Long> getCountByResourceType() {
            if (this.countByResourceType instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.countByResourceType;
        }

        public final void setCountByResourceType(Map<String, Long> countByResourceType) {
            this.countByResourceType = CountByResourceTypeCopier.copy(countByResourceType);
        }

        @Override
        public final Builder countByResourceTypeWithStrings(Map<String, Long> countByResourceType) {
            this.countByResourceType = CountByResourceTypeCopier.copy(countByResourceType);
            return this;
        }

        @Override
        public final Builder countByResourceType(Map<ResourceType, Long> countByResourceType) {
            this.countByResourceType = CountByResourceTypeCopier.copyEnumToString(countByResourceType);
            return this;
        }

        public final Map<String, Long> getCountByCoverageStatus() {
            if (this.countByCoverageStatus instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.countByCoverageStatus;
        }

        public final void setCountByCoverageStatus(Map<String, Long> countByCoverageStatus) {
            this.countByCoverageStatus = CountByCoverageStatusCopier.copy(countByCoverageStatus);
        }

        @Override
        public final Builder countByCoverageStatusWithStrings(Map<String, Long> countByCoverageStatus) {
            this.countByCoverageStatus = CountByCoverageStatusCopier.copy(countByCoverageStatus);
            return this;
        }

        @Override
        public final Builder countByCoverageStatus(Map<CoverageStatus, Long> countByCoverageStatus) {
            this.countByCoverageStatus = CountByCoverageStatusCopier.copyEnumToString(countByCoverageStatus);
            return this;
        }

        public CoverageStatistics build() {
            return new CoverageStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoverageStatistics> {
        public Builder countByResourceTypeWithStrings(Map<String, Long> var1);

        public Builder countByResourceType(Map<ResourceType, Long> var1);

        public Builder countByCoverageStatusWithStrings(Map<String, Long> var1);

        public Builder countByCoverageStatus(Map<CoverageStatus, Long> var1);
    }
}

