/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.Total;
import software.amazon.awssdk.services.guardduty.model.UsageFeature;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UsageFeatureResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UsageFeatureResult> {
    private static final SdkField<String> FEATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Feature").getter(UsageFeatureResult.getter(UsageFeatureResult::featureAsString)).setter(UsageFeatureResult.setter(Builder::feature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("feature").build()}).build();
    private static final SdkField<Total> TOTAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Total").getter(UsageFeatureResult.getter(UsageFeatureResult::total)).setter(UsageFeatureResult.setter(Builder::total)).constructor(Total::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_FIELD, TOTAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UsageFeatureResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String feature;
    private final Total total;

    private UsageFeatureResult(BuilderImpl builder) {
        this.feature = builder.feature;
        this.total = builder.total;
    }

    public final UsageFeature feature() {
        return UsageFeature.fromValue(this.feature);
    }

    public final String featureAsString() {
        return this.feature;
    }

    public final Total total() {
        return this.total;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.featureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageFeatureResult)) {
            return false;
        }
        UsageFeatureResult other = (UsageFeatureResult)obj;
        return Objects.equals(this.featureAsString(), other.featureAsString()) && Objects.equals(this.total(), other.total());
    }

    public final String toString() {
        return ToString.builder((String)"UsageFeatureResult").add("Feature", (Object)this.featureAsString()).add("Total", (Object)this.total()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Feature": {
                return Optional.ofNullable(clazz.cast(this.featureAsString()));
            }
            case "Total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("feature", FEATURE_FIELD);
        map.put("total", TOTAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UsageFeatureResult, T> g) {
        return obj -> g.apply((UsageFeatureResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String feature;
        private Total total;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageFeatureResult model) {
            this.feature(model.feature);
            this.total(model.total);
        }

        public final String getFeature() {
            return this.feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public final Builder feature(UsageFeature feature) {
            this.feature(feature == null ? null : feature.toString());
            return this;
        }

        public final Total.Builder getTotal() {
            return this.total != null ? this.total.toBuilder() : null;
        }

        public final void setTotal(Total.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        @Override
        public final Builder total(Total total) {
            this.total = total;
            return this;
        }

        public UsageFeatureResult build() {
            return new UsageFeatureResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UsageFeatureResult> {
        public Builder feature(String var1);

        public Builder feature(UsageFeature var1);

        public Builder total(Total var1);

        default public Builder total(Consumer<Total.Builder> total) {
            return this.total((Total)((Total.Builder)Total.builder().applyMutation(total)).build());
        }
    }
}

