/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.OrganizationFeatureStatistics;
import software.amazon.awssdk.services.guardduty.model.OrganizationFeatureStatisticsResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationStatistics> {
    private static final SdkField<Integer> TOTAL_ACCOUNTS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalAccountsCount").getter(OrganizationStatistics.getter(OrganizationStatistics::totalAccountsCount)).setter(OrganizationStatistics.setter(Builder::totalAccountsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalAccountsCount").build()}).build();
    private static final SdkField<Integer> MEMBER_ACCOUNTS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MemberAccountsCount").getter(OrganizationStatistics.getter(OrganizationStatistics::memberAccountsCount)).setter(OrganizationStatistics.setter(Builder::memberAccountsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountsCount").build()}).build();
    private static final SdkField<Integer> ACTIVE_ACCOUNTS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ActiveAccountsCount").getter(OrganizationStatistics.getter(OrganizationStatistics::activeAccountsCount)).setter(OrganizationStatistics.setter(Builder::activeAccountsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeAccountsCount").build()}).build();
    private static final SdkField<Integer> ENABLED_ACCOUNTS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EnabledAccountsCount").getter(OrganizationStatistics.getter(OrganizationStatistics::enabledAccountsCount)).setter(OrganizationStatistics.setter(Builder::enabledAccountsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledAccountsCount").build()}).build();
    private static final SdkField<List<OrganizationFeatureStatistics>> COUNT_BY_FEATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CountByFeature").getter(OrganizationStatistics.getter(OrganizationStatistics::countByFeature)).setter(OrganizationStatistics.setter(Builder::countByFeature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countByFeature").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrganizationFeatureStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_ACCOUNTS_COUNT_FIELD, MEMBER_ACCOUNTS_COUNT_FIELD, ACTIVE_ACCOUNTS_COUNT_FIELD, ENABLED_ACCOUNTS_COUNT_FIELD, COUNT_BY_FEATURE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OrganizationStatistics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer totalAccountsCount;
    private final Integer memberAccountsCount;
    private final Integer activeAccountsCount;
    private final Integer enabledAccountsCount;
    private final List<OrganizationFeatureStatistics> countByFeature;

    private OrganizationStatistics(BuilderImpl builder) {
        this.totalAccountsCount = builder.totalAccountsCount;
        this.memberAccountsCount = builder.memberAccountsCount;
        this.activeAccountsCount = builder.activeAccountsCount;
        this.enabledAccountsCount = builder.enabledAccountsCount;
        this.countByFeature = builder.countByFeature;
    }

    public final Integer totalAccountsCount() {
        return this.totalAccountsCount;
    }

    public final Integer memberAccountsCount() {
        return this.memberAccountsCount;
    }

    public final Integer activeAccountsCount() {
        return this.activeAccountsCount;
    }

    public final Integer enabledAccountsCount() {
        return this.enabledAccountsCount;
    }

    public final boolean hasCountByFeature() {
        return this.countByFeature != null && !(this.countByFeature instanceof SdkAutoConstructList);
    }

    public final List<OrganizationFeatureStatistics> countByFeature() {
        return this.countByFeature;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalAccountsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberAccountsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeAccountsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledAccountsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCountByFeature() ? this.countByFeature() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationStatistics)) {
            return false;
        }
        OrganizationStatistics other = (OrganizationStatistics)obj;
        return Objects.equals(this.totalAccountsCount(), other.totalAccountsCount()) && Objects.equals(this.memberAccountsCount(), other.memberAccountsCount()) && Objects.equals(this.activeAccountsCount(), other.activeAccountsCount()) && Objects.equals(this.enabledAccountsCount(), other.enabledAccountsCount()) && this.hasCountByFeature() == other.hasCountByFeature() && Objects.equals(this.countByFeature(), other.countByFeature());
    }

    public final String toString() {
        return ToString.builder((String)"OrganizationStatistics").add("TotalAccountsCount", (Object)this.totalAccountsCount()).add("MemberAccountsCount", (Object)this.memberAccountsCount()).add("ActiveAccountsCount", (Object)this.activeAccountsCount()).add("EnabledAccountsCount", (Object)this.enabledAccountsCount()).add("CountByFeature", this.hasCountByFeature() ? this.countByFeature() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalAccountsCount": {
                return Optional.ofNullable(clazz.cast(this.totalAccountsCount()));
            }
            case "MemberAccountsCount": {
                return Optional.ofNullable(clazz.cast(this.memberAccountsCount()));
            }
            case "ActiveAccountsCount": {
                return Optional.ofNullable(clazz.cast(this.activeAccountsCount()));
            }
            case "EnabledAccountsCount": {
                return Optional.ofNullable(clazz.cast(this.enabledAccountsCount()));
            }
            case "CountByFeature": {
                return Optional.ofNullable(clazz.cast(this.countByFeature()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("totalAccountsCount", TOTAL_ACCOUNTS_COUNT_FIELD);
        map.put("memberAccountsCount", MEMBER_ACCOUNTS_COUNT_FIELD);
        map.put("activeAccountsCount", ACTIVE_ACCOUNTS_COUNT_FIELD);
        map.put("enabledAccountsCount", ENABLED_ACCOUNTS_COUNT_FIELD);
        map.put("countByFeature", COUNT_BY_FEATURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrganizationStatistics, T> g) {
        return obj -> g.apply((OrganizationStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer totalAccountsCount;
        private Integer memberAccountsCount;
        private Integer activeAccountsCount;
        private Integer enabledAccountsCount;
        private List<OrganizationFeatureStatistics> countByFeature = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationStatistics model) {
            this.totalAccountsCount(model.totalAccountsCount);
            this.memberAccountsCount(model.memberAccountsCount);
            this.activeAccountsCount(model.activeAccountsCount);
            this.enabledAccountsCount(model.enabledAccountsCount);
            this.countByFeature(model.countByFeature);
        }

        public final Integer getTotalAccountsCount() {
            return this.totalAccountsCount;
        }

        public final void setTotalAccountsCount(Integer totalAccountsCount) {
            this.totalAccountsCount = totalAccountsCount;
        }

        @Override
        public final Builder totalAccountsCount(Integer totalAccountsCount) {
            this.totalAccountsCount = totalAccountsCount;
            return this;
        }

        public final Integer getMemberAccountsCount() {
            return this.memberAccountsCount;
        }

        public final void setMemberAccountsCount(Integer memberAccountsCount) {
            this.memberAccountsCount = memberAccountsCount;
        }

        @Override
        public final Builder memberAccountsCount(Integer memberAccountsCount) {
            this.memberAccountsCount = memberAccountsCount;
            return this;
        }

        public final Integer getActiveAccountsCount() {
            return this.activeAccountsCount;
        }

        public final void setActiveAccountsCount(Integer activeAccountsCount) {
            this.activeAccountsCount = activeAccountsCount;
        }

        @Override
        public final Builder activeAccountsCount(Integer activeAccountsCount) {
            this.activeAccountsCount = activeAccountsCount;
            return this;
        }

        public final Integer getEnabledAccountsCount() {
            return this.enabledAccountsCount;
        }

        public final void setEnabledAccountsCount(Integer enabledAccountsCount) {
            this.enabledAccountsCount = enabledAccountsCount;
        }

        @Override
        public final Builder enabledAccountsCount(Integer enabledAccountsCount) {
            this.enabledAccountsCount = enabledAccountsCount;
            return this;
        }

        public final List<OrganizationFeatureStatistics.Builder> getCountByFeature() {
            List<OrganizationFeatureStatistics.Builder> result = OrganizationFeatureStatisticsResultsCopier.copyToBuilder(this.countByFeature);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCountByFeature(Collection<OrganizationFeatureStatistics.BuilderImpl> countByFeature) {
            this.countByFeature = OrganizationFeatureStatisticsResultsCopier.copyFromBuilder(countByFeature);
        }

        @Override
        public final Builder countByFeature(Collection<OrganizationFeatureStatistics> countByFeature) {
            this.countByFeature = OrganizationFeatureStatisticsResultsCopier.copy(countByFeature);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countByFeature(OrganizationFeatureStatistics ... countByFeature) {
            this.countByFeature(Arrays.asList(countByFeature));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countByFeature(Consumer<OrganizationFeatureStatistics.Builder> ... countByFeature) {
            this.countByFeature(Stream.of(countByFeature).map(c -> (OrganizationFeatureStatistics)((OrganizationFeatureStatistics.Builder)OrganizationFeatureStatistics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public OrganizationStatistics build() {
            return new OrganizationStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationStatistics> {
        public Builder totalAccountsCount(Integer var1);

        public Builder memberAccountsCount(Integer var1);

        public Builder activeAccountsCount(Integer var1);

        public Builder enabledAccountsCount(Integer var1);

        public Builder countByFeature(Collection<OrganizationFeatureStatistics> var1);

        public Builder countByFeature(OrganizationFeatureStatistics ... var1);

        public Builder countByFeature(Consumer<OrganizationFeatureStatistics.Builder> ... var1);
    }
}

