/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.KubernetesConfiguration;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionConfiguration;
import software.amazon.awssdk.services.guardduty.model.S3LogsConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceConfigurations
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceConfigurations> {
    private static final SdkField<S3LogsConfiguration> S3_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Logs").getter(DataSourceConfigurations.getter(DataSourceConfigurations::s3Logs)).setter(DataSourceConfigurations.setter(Builder::s3Logs)).constructor(S3LogsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Logs").build()}).build();
    private static final SdkField<KubernetesConfiguration> KUBERNETES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Kubernetes").getter(DataSourceConfigurations.getter(DataSourceConfigurations::kubernetes)).setter(DataSourceConfigurations.setter(Builder::kubernetes)).constructor(KubernetesConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetes").build()}).build();
    private static final SdkField<MalwareProtectionConfiguration> MALWARE_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MalwareProtection").getter(DataSourceConfigurations.getter(DataSourceConfigurations::malwareProtection)).setter(DataSourceConfigurations.setter(Builder::malwareProtection)).constructor(MalwareProtectionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("malwareProtection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_LOGS_FIELD, KUBERNETES_FIELD, MALWARE_PROTECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSourceConfigurations.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3LogsConfiguration s3Logs;
    private final KubernetesConfiguration kubernetes;
    private final MalwareProtectionConfiguration malwareProtection;

    private DataSourceConfigurations(BuilderImpl builder) {
        this.s3Logs = builder.s3Logs;
        this.kubernetes = builder.kubernetes;
        this.malwareProtection = builder.malwareProtection;
    }

    public final S3LogsConfiguration s3Logs() {
        return this.s3Logs;
    }

    public final KubernetesConfiguration kubernetes() {
        return this.kubernetes;
    }

    public final MalwareProtectionConfiguration malwareProtection() {
        return this.malwareProtection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Logs());
        hashCode = 31 * hashCode + Objects.hashCode(this.kubernetes());
        hashCode = 31 * hashCode + Objects.hashCode(this.malwareProtection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfigurations)) {
            return false;
        }
        DataSourceConfigurations other = (DataSourceConfigurations)obj;
        return Objects.equals(this.s3Logs(), other.s3Logs()) && Objects.equals(this.kubernetes(), other.kubernetes()) && Objects.equals(this.malwareProtection(), other.malwareProtection());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourceConfigurations").add("S3Logs", (Object)this.s3Logs()).add("Kubernetes", (Object)this.kubernetes()).add("MalwareProtection", (Object)this.malwareProtection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Logs": {
                return Optional.ofNullable(clazz.cast(this.s3Logs()));
            }
            case "Kubernetes": {
                return Optional.ofNullable(clazz.cast(this.kubernetes()));
            }
            case "MalwareProtection": {
                return Optional.ofNullable(clazz.cast(this.malwareProtection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("s3Logs", S3_LOGS_FIELD);
        map.put("kubernetes", KUBERNETES_FIELD);
        map.put("malwareProtection", MALWARE_PROTECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceConfigurations, T> g) {
        return obj -> g.apply((DataSourceConfigurations)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3LogsConfiguration s3Logs;
        private KubernetesConfiguration kubernetes;
        private MalwareProtectionConfiguration malwareProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceConfigurations model) {
            this.s3Logs(model.s3Logs);
            this.kubernetes(model.kubernetes);
            this.malwareProtection(model.malwareProtection);
        }

        public final S3LogsConfiguration.Builder getS3Logs() {
            return this.s3Logs != null ? this.s3Logs.toBuilder() : null;
        }

        public final void setS3Logs(S3LogsConfiguration.BuilderImpl s3Logs) {
            this.s3Logs = s3Logs != null ? s3Logs.build() : null;
        }

        @Override
        public final Builder s3Logs(S3LogsConfiguration s3Logs) {
            this.s3Logs = s3Logs;
            return this;
        }

        public final KubernetesConfiguration.Builder getKubernetes() {
            return this.kubernetes != null ? this.kubernetes.toBuilder() : null;
        }

        public final void setKubernetes(KubernetesConfiguration.BuilderImpl kubernetes) {
            this.kubernetes = kubernetes != null ? kubernetes.build() : null;
        }

        @Override
        public final Builder kubernetes(KubernetesConfiguration kubernetes) {
            this.kubernetes = kubernetes;
            return this;
        }

        public final MalwareProtectionConfiguration.Builder getMalwareProtection() {
            return this.malwareProtection != null ? this.malwareProtection.toBuilder() : null;
        }

        public final void setMalwareProtection(MalwareProtectionConfiguration.BuilderImpl malwareProtection) {
            this.malwareProtection = malwareProtection != null ? malwareProtection.build() : null;
        }

        @Override
        public final Builder malwareProtection(MalwareProtectionConfiguration malwareProtection) {
            this.malwareProtection = malwareProtection;
            return this;
        }

        public DataSourceConfigurations build() {
            return new DataSourceConfigurations(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceConfigurations> {
        public Builder s3Logs(S3LogsConfiguration var1);

        default public Builder s3Logs(Consumer<S3LogsConfiguration.Builder> s3Logs) {
            return this.s3Logs((S3LogsConfiguration)((S3LogsConfiguration.Builder)S3LogsConfiguration.builder().applyMutation(s3Logs)).build());
        }

        public Builder kubernetes(KubernetesConfiguration var1);

        default public Builder kubernetes(Consumer<KubernetesConfiguration.Builder> kubernetes) {
            return this.kubernetes((KubernetesConfiguration)((KubernetesConfiguration.Builder)KubernetesConfiguration.builder().applyMutation(kubernetes)).build());
        }

        public Builder malwareProtection(MalwareProtectionConfiguration var1);

        default public Builder malwareProtection(Consumer<MalwareProtectionConfiguration.Builder> malwareProtection) {
            return this.malwareProtection((MalwareProtectionConfiguration)((MalwareProtectionConfiguration.Builder)MalwareProtectionConfiguration.builder().applyMutation(malwareProtection)).build());
        }
    }
}

