/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountStatistics> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(AccountStatistics.getter(AccountStatistics::accountId)).setter(AccountStatistics.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<Instant> LAST_GENERATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastGeneratedAt").getter(AccountStatistics.getter(AccountStatistics::lastGeneratedAt)).setter(AccountStatistics.setter(Builder::lastGeneratedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastGeneratedAt").build()}).build();
    private static final SdkField<Integer> TOTAL_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalFindings").getter(AccountStatistics.getter(AccountStatistics::totalFindings)).setter(AccountStatistics.setter(Builder::totalFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalFindings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, LAST_GENERATED_AT_FIELD, TOTAL_FINDINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountStatistics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final Instant lastGeneratedAt;
    private final Integer totalFindings;

    private AccountStatistics(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.lastGeneratedAt = builder.lastGeneratedAt;
        this.totalFindings = builder.totalFindings;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final Instant lastGeneratedAt() {
        return this.lastGeneratedAt;
    }

    public final Integer totalFindings() {
        return this.totalFindings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastGeneratedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalFindings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountStatistics)) {
            return false;
        }
        AccountStatistics other = (AccountStatistics)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.lastGeneratedAt(), other.lastGeneratedAt()) && Objects.equals(this.totalFindings(), other.totalFindings());
    }

    public final String toString() {
        return ToString.builder((String)"AccountStatistics").add("AccountId", (Object)this.accountId()).add("LastGeneratedAt", (Object)this.lastGeneratedAt()).add("TotalFindings", (Object)this.totalFindings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "LastGeneratedAt": {
                return Optional.ofNullable(clazz.cast(this.lastGeneratedAt()));
            }
            case "TotalFindings": {
                return Optional.ofNullable(clazz.cast(this.totalFindings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("lastGeneratedAt", LAST_GENERATED_AT_FIELD);
        map.put("totalFindings", TOTAL_FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountStatistics, T> g) {
        return obj -> g.apply((AccountStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private Instant lastGeneratedAt;
        private Integer totalFindings;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountStatistics model) {
            this.accountId(model.accountId);
            this.lastGeneratedAt(model.lastGeneratedAt);
            this.totalFindings(model.totalFindings);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Instant getLastGeneratedAt() {
            return this.lastGeneratedAt;
        }

        public final void setLastGeneratedAt(Instant lastGeneratedAt) {
            this.lastGeneratedAt = lastGeneratedAt;
        }

        @Override
        public final Builder lastGeneratedAt(Instant lastGeneratedAt) {
            this.lastGeneratedAt = lastGeneratedAt;
            return this;
        }

        public final Integer getTotalFindings() {
            return this.totalFindings;
        }

        public final void setTotalFindings(Integer totalFindings) {
            this.totalFindings = totalFindings;
        }

        @Override
        public final Builder totalFindings(Integer totalFindings) {
            this.totalFindings = totalFindings;
            return this;
        }

        public AccountStatistics build() {
            return new AccountStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountStatistics> {
        public Builder accountId(String var1);

        public Builder lastGeneratedAt(Instant var1);

        public Builder totalFindings(Integer var1);
    }
}

