/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IndicatorType {
    SUSPICIOUS_USER_AGENT("SUSPICIOUS_USER_AGENT"),
    SUSPICIOUS_NETWORK("SUSPICIOUS_NETWORK"),
    MALICIOUS_IP("MALICIOUS_IP"),
    TOR_IP("TOR_IP"),
    ATTACK_TACTIC("ATTACK_TACTIC"),
    HIGH_RISK_API("HIGH_RISK_API"),
    ATTACK_TECHNIQUE("ATTACK_TECHNIQUE"),
    UNUSUAL_API_FOR_ACCOUNT("UNUSUAL_API_FOR_ACCOUNT"),
    UNUSUAL_ASN_FOR_ACCOUNT("UNUSUAL_ASN_FOR_ACCOUNT"),
    UNUSUAL_ASN_FOR_USER("UNUSUAL_ASN_FOR_USER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IndicatorType> VALUE_MAP;
    private final String value;

    private IndicatorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IndicatorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IndicatorType> knownValues() {
        EnumSet<IndicatorType> knownValues = EnumSet.allOf(IndicatorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IndicatorType.class, IndicatorType::toString);
    }
}

