/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.CriterionKey;
import software.amazon.awssdk.services.guardduty.model.FilterCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterCriterion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterCriterion> {
    private static final SdkField<String> CRITERION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CriterionKey").getter(FilterCriterion.getter(FilterCriterion::criterionKeyAsString)).setter(FilterCriterion.setter(Builder::criterionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("criterionKey").build()}).build();
    private static final SdkField<FilterCondition> FILTER_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterCondition").getter(FilterCriterion.getter(FilterCriterion::filterCondition)).setter(FilterCriterion.setter(Builder::filterCondition)).constructor(FilterCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRITERION_KEY_FIELD, FILTER_CONDITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FilterCriterion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String criterionKey;
    private final FilterCondition filterCondition;

    private FilterCriterion(BuilderImpl builder) {
        this.criterionKey = builder.criterionKey;
        this.filterCondition = builder.filterCondition;
    }

    public final CriterionKey criterionKey() {
        return CriterionKey.fromValue(this.criterionKey);
    }

    public final String criterionKeyAsString() {
        return this.criterionKey;
    }

    public final FilterCondition filterCondition() {
        return this.filterCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.criterionKeyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterCondition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterCriterion)) {
            return false;
        }
        FilterCriterion other = (FilterCriterion)obj;
        return Objects.equals(this.criterionKeyAsString(), other.criterionKeyAsString()) && Objects.equals(this.filterCondition(), other.filterCondition());
    }

    public final String toString() {
        return ToString.builder((String)"FilterCriterion").add("CriterionKey", (Object)this.criterionKeyAsString()).add("FilterCondition", (Object)this.filterCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CriterionKey": {
                return Optional.ofNullable(clazz.cast(this.criterionKeyAsString()));
            }
            case "FilterCondition": {
                return Optional.ofNullable(clazz.cast(this.filterCondition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("criterionKey", CRITERION_KEY_FIELD);
        map.put("filterCondition", FILTER_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterCriterion, T> g) {
        return obj -> g.apply((FilterCriterion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String criterionKey;
        private FilterCondition filterCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterCriterion model) {
            this.criterionKey(model.criterionKey);
            this.filterCondition(model.filterCondition);
        }

        public final String getCriterionKey() {
            return this.criterionKey;
        }

        public final void setCriterionKey(String criterionKey) {
            this.criterionKey = criterionKey;
        }

        @Override
        public final Builder criterionKey(String criterionKey) {
            this.criterionKey = criterionKey;
            return this;
        }

        @Override
        public final Builder criterionKey(CriterionKey criterionKey) {
            this.criterionKey(criterionKey == null ? null : criterionKey.toString());
            return this;
        }

        public final FilterCondition.Builder getFilterCondition() {
            return this.filterCondition != null ? this.filterCondition.toBuilder() : null;
        }

        public final void setFilterCondition(FilterCondition.BuilderImpl filterCondition) {
            this.filterCondition = filterCondition != null ? filterCondition.build() : null;
        }

        @Override
        public final Builder filterCondition(FilterCondition filterCondition) {
            this.filterCondition = filterCondition;
            return this;
        }

        public FilterCriterion build() {
            return new FilterCriterion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterCriterion> {
        public Builder criterionKey(String var1);

        public Builder criterionKey(CriterionKey var1);

        public Builder filterCondition(FilterCondition var1);

        default public Builder filterCondition(Consumer<FilterCondition.Builder> filterCondition) {
            return this.filterCondition((FilterCondition)((FilterCondition.Builder)FilterCondition.builder().applyMutation(filterCondition)).build());
        }
    }
}

